/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.quorum.AckRequestProcessor;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerSyncRequest;

public class ProposalRequestProcessor
implements RequestProcessor {
    LeaderZooKeeperServer zks;
    RequestProcessor nextProcessor;
    SyncRequestProcessor syncProcessor;

    public ProposalRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        AckRequestProcessor ackProcessor = new AckRequestProcessor(zks.getLeader());
        this.syncProcessor = new SyncRequestProcessor(zks, ackProcessor);
    }

    public void initialize() {
        this.syncProcessor.start();
    }

    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (request instanceof LearnerSyncRequest) {
            this.zks.getLeader().processSync((LearnerSyncRequest)request);
        } else {
            this.nextProcessor.processRequest(request);
            if (request.hdr != null) {
                try {
                    this.zks.getLeader().propose(request);
                }
                catch (Leader.XidRolloverException e) {
                    throw new RequestProcessor.RequestProcessorException(e.getMessage(), e);
                }
                this.syncProcessor.processRequest(request);
            }
        }
    }

    public void shutdown() {
        this.nextProcessor.shutdown();
        this.syncProcessor.shutdown();
    }
}

