/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.hdfs.AbstractHDFSWriter;
import org.apache.flume.sink.hdfs.SequenceFileSerializer;
import org.apache.flume.sink.hdfs.SequenceFileSerializerFactory;
import org.apache.flume.sink.hdfs.SequenceFileSerializerType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSSequenceFile
extends AbstractHDFSWriter {
    private static final Logger logger = LoggerFactory.getLogger(HDFSSequenceFile.class);
    private SequenceFile.Writer writer = null;
    private String writeFormat;
    private Context serializerContext;
    private SequenceFileSerializer serializer;
    private boolean useRawLocalFileSystem;
    private FSDataOutputStream outStream = null;

    @Override
    public void configure(Context context) {
        super.configure(context);
        this.writeFormat = context.getString("hdfs.writeFormat", SequenceFileSerializerType.Writable.name());
        this.useRawLocalFileSystem = context.getBoolean("hdfs.useRawLocalFileSystem", Boolean.valueOf(false));
        this.serializerContext = new Context((Map)context.getSubProperties("writeFormat."));
        this.serializer = SequenceFileSerializerFactory.getSerializer(this.writeFormat, this.serializerContext);
        logger.info("writeFormat = " + this.writeFormat + ", UseRawLocalFileSystem = " + this.useRawLocalFileSystem);
    }

    @Override
    public void open(String filePath) throws IOException {
        this.open(filePath, null, SequenceFile.CompressionType.NONE);
    }

    @Override
    public void open(String filePath, CompressionCodec codeC, SequenceFile.CompressionType compType) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = dstPath.getFileSystem(conf);
        if (this.useRawLocalFileSystem) {
            if (hdfs instanceof LocalFileSystem) {
                hdfs = ((LocalFileSystem)hdfs).getRaw();
            } else {
                logger.warn("useRawLocalFileSystem is set to true but file system is not of type LocalFileSystem: " + hdfs.getClass().getName());
            }
        }
        this.outStream = conf.getBoolean("hdfs.append.support", false) && hdfs.isFile(dstPath) ? hdfs.append(dstPath) : hdfs.create(dstPath);
        this.writer = SequenceFile.createWriter((Configuration)conf, (FSDataOutputStream)this.outStream, this.serializer.getKeyClass(), this.serializer.getValueClass(), (SequenceFile.CompressionType)compType, (CompressionCodec)codeC);
        this.registerCurrentStream(this.outStream, hdfs, dstPath);
    }

    @Override
    public void append(Event e) throws IOException {
        for (SequenceFileSerializer.Record record : this.serializer.serialize(e)) {
            this.writer.append(record.getKey(), record.getValue());
        }
    }

    @Override
    public void sync() throws IOException {
        this.writer.syncFs();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.outStream.close();
        this.unregisterCurrentStream();
    }
}

