/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node.nodemanager;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.SourceRunner;
import org.apache.flume.instrumentation.MonitorService;
import org.apache.flume.instrumentation.MonitoringType;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.lifecycle.LifecycleSupervisor;
import org.apache.flume.node.NodeConfiguration;
import org.apache.flume.node.nodemanager.AbstractLogicalNodeManager;
import org.apache.flume.node.nodemanager.NodeConfigurationAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogicalNodeManager
extends AbstractLogicalNodeManager
implements NodeConfigurationAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLogicalNodeManager.class);
    private LifecycleSupervisor nodeSupervisor = new LifecycleSupervisor();
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private NodeConfiguration nodeConfiguration = null;
    private MonitorService monitorServer;
    public static final String CONF_MONITOR_CLASS = "flume.monitoring.type";
    public static final String CONF_MONITOR_PREFIX = "flume.monitoring.";

    @Override
    public void stopAllComponents() {
        if (this.nodeConfiguration != null) {
            logger.info("Shutting down configuration: {}", (Object)this.nodeConfiguration);
            for (Map.Entry<String, SourceRunner> entry : this.nodeConfiguration.getSourceRunners().entrySet()) {
                try {
                    logger.info("Stopping Source " + entry.getKey());
                    this.nodeSupervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", (Object)entry.getValue(), (Object)e);
                }
            }
            for (Map.Entry<String, SourceRunner> entry : this.nodeConfiguration.getSinkRunners().entrySet()) {
                try {
                    logger.info("Stopping Sink " + entry.getKey());
                    this.nodeSupervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", (Object)entry.getValue(), (Object)e);
                }
            }
            for (Map.Entry<String, SourceRunner> entry : this.nodeConfiguration.getChannels().entrySet()) {
                try {
                    logger.info("Stopping Channel " + entry.getKey());
                    this.nodeSupervisor.unsupervise((LifecycleAware)entry.getValue());
                }
                catch (Exception e) {
                    logger.error("Error while stopping {}", (Object)entry.getValue(), (Object)e);
                }
            }
        }
        if (this.monitorServer != null) {
            this.monitorServer.stop();
        }
    }

    @Override
    public void startAllComponents(NodeConfiguration nodeConfiguration) {
        logger.info("Starting new configuration:{}", (Object)nodeConfiguration);
        this.nodeConfiguration = nodeConfiguration;
        for (Map.Entry<String, Channel> entry : nodeConfiguration.getChannels().entrySet()) {
            try {
                logger.info("Starting Channel " + entry.getKey());
                this.nodeSupervisor.supervise((LifecycleAware)entry.getValue(), (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", (Object)entry.getValue(), (Object)e);
            }
        }
        for (Channel channel : nodeConfiguration.getChannels().values()) {
            while (channel.getLifecycleState() != LifecycleState.START && !this.nodeSupervisor.isComponentInErrorState((LifecycleAware)channel)) {
                try {
                    logger.info("Waiting for channel: " + channel.getName() + " to start. Sleeping for 500 ms");
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for channel to start.", (Throwable)e);
                    Throwables.propagate((Throwable)e);
                }
            }
        }
        for (Map.Entry<String, Channel> entry : nodeConfiguration.getSinkRunners().entrySet()) {
            try {
                logger.info("Starting Sink " + entry.getKey());
                this.nodeSupervisor.supervise((LifecycleAware)entry.getValue(), (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", (Object)entry.getValue(), (Object)e);
            }
        }
        for (Map.Entry<String, Channel> entry : nodeConfiguration.getSourceRunners().entrySet()) {
            try {
                logger.info("Starting Source " + entry.getKey());
                this.nodeSupervisor.supervise((LifecycleAware)entry.getValue(), (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            }
            catch (Exception e) {
                logger.error("Error while starting {}", (Object)entry.getValue(), (Object)e);
            }
        }
        this.loadMonitoring();
    }

    @Override
    public boolean add(LifecycleAware node) {
        Preconditions.checkState((boolean)this.getLifecycleState().equals((Object)LifecycleState.START), (Object)"You can not add nodes to a manager that hasn't been started");
        if (super.add(node)) {
            this.nodeSupervisor.supervise(node, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(LifecycleAware node) {
        Preconditions.checkState((boolean)this.getLifecycleState().equals((Object)LifecycleState.START), (Object)"You can not remove nodes from a manager that hasn't been started");
        if (super.remove(node)) {
            this.nodeSupervisor.unsupervise(node);
            return true;
        }
        return false;
    }

    public void start() {
        logger.info("Node manager starting");
        this.nodeSupervisor.start();
        logger.debug("Node manager started");
        this.lifecycleState = LifecycleState.START;
    }

    public void stop() {
        logger.info("Node manager stopping");
        this.stopAllComponents();
        this.nodeSupervisor.stop();
        logger.debug("Node manager stopped");
        this.lifecycleState = LifecycleState.STOP;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    private void loadMonitoring() {
        block5: {
            Properties systemProps = System.getProperties();
            Set<String> keys = systemProps.stringPropertyNames();
            try {
                Class<?> klass;
                if (!keys.contains(CONF_MONITOR_CLASS)) break block5;
                String monitorType = systemProps.getProperty(CONF_MONITOR_CLASS);
                try {
                    klass = MonitoringType.valueOf((String)monitorType.toUpperCase()).getMonitorClass();
                }
                catch (Exception e) {
                    klass = Class.forName(monitorType);
                }
                this.monitorServer = (MonitorService)klass.newInstance();
                Context context = new Context();
                for (String key : keys) {
                    if (!key.startsWith(CONF_MONITOR_PREFIX)) continue;
                    context.put(key.substring(CONF_MONITOR_PREFIX.length()), systemProps.getProperty(key));
                }
                this.monitorServer.configure(context);
                this.monitorServer.start();
            }
            catch (Exception e) {
                logger.warn("Error starting monitoring. Monitoring might not be available.", (Throwable)e);
            }
        }
    }
}

