/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.file;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelFactory;
import org.apache.flume.CounterGroup;
import org.apache.flume.SinkFactory;
import org.apache.flume.SourceFactory;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.ConfigurationProvider;
import org.apache.flume.node.nodemanager.NodeConfigurationAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileConfigurationProvider
implements ConfigurationProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File file;
    private ChannelFactory channelFactory;
    private SourceFactory sourceFactory;
    private SinkFactory sinkFactory;
    private String nodeName;
    private NodeConfigurationAware configurationAware;
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private ScheduledExecutorService executorService;
    private CounterGroup counterGroup = new CounterGroup();

    public String toString() {
        return "{ file:" + this.file + " counterGroup:" + this.counterGroup + "  provider:" + this.getClass().getCanonicalName() + " nodeName:" + this.nodeName + " }";
    }

    public void start() {
        this.logger.info("Configuration provider starting");
        Preconditions.checkState((this.file != null ? 1 : 0) != 0, (Object)"The parameter file must not be null");
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("conf-file-poller-%d").build());
        FileWatcherRunnable fileWatcherRunnable = new FileWatcherRunnable();
        fileWatcherRunnable.file = this.file;
        fileWatcherRunnable.counterGroup = this.counterGroup;
        this.executorService.scheduleWithFixedDelay(fileWatcherRunnable, 0L, 30L, TimeUnit.SECONDS);
        this.lifecycleState = LifecycleState.START;
        this.logger.debug("Configuration provider started");
    }

    public void stop() {
        this.logger.info("Configuration provider stopping");
        this.executorService.shutdown();
        while (!this.executorService.isTerminated()) {
            try {
                this.logger.debug("Waiting for file watcher to terminate");
                this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.logger.debug("Interrupted while waiting for file watcher to terminate");
                Thread.currentThread().interrupt();
            }
        }
        this.lifecycleState = LifecycleState.STOP;
        this.logger.debug("Configuration provider stopped");
    }

    protected abstract void load();

    private synchronized void doLoad() {
        Preconditions.checkState((this.nodeName != null ? 1 : 0) != 0, (Object)"No node name specified - Unable to determine what part of the config to load");
        Preconditions.checkState((this.channelFactory != null ? 1 : 0) != 0, (Object)"No channel factory configured");
        Preconditions.checkState((this.sourceFactory != null ? 1 : 0) != 0, (Object)"No source factory configured");
        Preconditions.checkState((this.sinkFactory != null ? 1 : 0) != 0, (Object)"No sink factory configured");
        this.load();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    public SinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    public void setSinkFactory(SinkFactory sinkFactory) {
        this.sinkFactory = sinkFactory;
    }

    public NodeConfigurationAware getConfigurationAware() {
        return this.configurationAware;
    }

    public void setConfigurationAware(NodeConfigurationAware configurationAware) {
        this.configurationAware = configurationAware;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public class FileWatcherRunnable
    implements Runnable {
        private File file;
        private CounterGroup counterGroup;
        private long lastChange;

        @Override
        public void run() {
            AbstractFileConfigurationProvider.this.logger.debug("Checking file:{} for changes", (Object)this.file);
            this.counterGroup.incrementAndGet("file.checks");
            long lastModified = this.file.lastModified();
            if (lastModified > this.lastChange) {
                AbstractFileConfigurationProvider.this.logger.info("Reloading configuration file:{}", (Object)this.file);
                this.counterGroup.incrementAndGet("file.loads");
                this.lastChange = lastModified;
                try {
                    AbstractFileConfigurationProvider.this.doLoad();
                }
                catch (Exception e) {
                    AbstractFileConfigurationProvider.this.logger.error("Failed to load configuration data. Exception follows.", (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    AbstractFileConfigurationProvider.this.logger.error("Failed to start agent because dependencies were not found in classpath. Error follows.", (Throwable)e);
                }
                catch (Throwable t) {
                    AbstractFileConfigurationProvider.this.logger.error("Unhandled error", t);
                }
            }
        }
    }
}

