/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.FlumeException;
import org.apache.flume.Source;
import org.apache.flume.SourceFactory;
import org.apache.flume.conf.source.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceFactory
implements SourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSourceFactory.class);
    private final Map<Class<?>, Map<String, Source>> sources = new HashMap();

    @Override
    public synchronized boolean unregister(Source source) {
        Preconditions.checkNotNull((Object)source);
        boolean removed = false;
        logger.debug("Unregistering source {}", (Object)source);
        Map<String, Source> sourceMap = this.sources.get(source.getClass());
        if (sourceMap != null) {
            boolean bl = removed = sourceMap.remove(source.getName()) != null;
            if (sourceMap.size() == 0) {
                this.sources.remove(source.getClass());
            }
        }
        return removed;
    }

    @Override
    public synchronized Source create(String name, String type) throws FlumeException {
        Source source;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        logger.debug("Creating instance of source {}, type {}", (Object)name, (Object)type);
        String sourceClassName = type;
        SourceType srcType = SourceType.OTHER;
        try {
            srcType = SourceType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Source type {} is a custom type", (Object)type);
        }
        if (!srcType.equals((Object)SourceType.OTHER)) {
            sourceClassName = srcType.getSourceClassName();
        }
        Class<?> sourceClass = null;
        try {
            sourceClass = Class.forName(sourceClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load source type: " + type + ", class: " + sourceClassName, (Throwable)ex);
        }
        Map<String, Source> sourceMap = this.sources.get(sourceClass);
        if (sourceMap == null) {
            sourceMap = new HashMap<String, Source>();
            this.sources.put(sourceClass, sourceMap);
        }
        if ((source = sourceMap.get(name)) == null) {
            try {
                source = (Source)sourceClass.newInstance();
                source.setName(name);
                sourceMap.put(name, source);
            }
            catch (Exception ex) {
                this.sources.remove(sourceClass);
                throw new FlumeException("Unable to create source: " + name + ", type: " + type + ", class: " + sourceClassName, (Throwable)ex);
            }
        }
        return source;
    }

    public synchronized Map<Class<?>, Map<String, Source>> getRegistryClone() {
        HashMap result = new HashMap();
        for (Class<?> klass : this.sources.keySet()) {
            Map<String, Source> srcMap = this.sources.get(klass);
            HashMap<String, Source> resultSrcMap = new HashMap<String, Source>();
            resultSrcMap.putAll(srcMap);
            result.put(klass, resultSrcMap);
        }
        return result;
    }
}

