/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Throwables;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.flume.source.avro.Status;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSource
extends AbstractSource
implements EventDrivenSource,
Configurable,
AvroSourceProtocol {
    private static final String THREADS = "threads";
    private static final Logger logger = LoggerFactory.getLogger(AvroSource.class);
    private int port;
    private String bindAddress;
    private Server server;
    private SourceCounter sourceCounter;
    private int maxThreads;
    private ScheduledExecutorService connectionCountUpdater;

    @Override
    public void configure(Context context) {
        this.port = Integer.parseInt(context.getString("port"));
        this.bindAddress = context.getString("bind");
        try {
            this.maxThreads = context.getInteger(THREADS, Integer.valueOf(0));
        }
        catch (NumberFormatException e) {
            logger.warn("AVRO source's \"threads\" property must specify an integer value.", (Object)context.getString(THREADS));
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        SpecificResponder responder = new SpecificResponder(AvroSourceProtocol.class, (Object)this);
        this.server = this.maxThreads <= 0 ? new NettyServer((Responder)responder, new InetSocketAddress(this.bindAddress, this.port)) : new NettyServer((Responder)responder, new InetSocketAddress(this.bindAddress, this.port), (ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newFixedThreadPool(this.maxThreads)));
        this.connectionCountUpdater = Executors.newSingleThreadScheduledExecutor();
        this.server.start();
        this.sourceCounter.start();
        super.start();
        final NettyServer srv = (NettyServer)this.server;
        this.connectionCountUpdater.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AvroSource.this.sourceCounter.setOpenConnectionCount(srv.getNumActiveConnections());
            }
        }, 0L, 60L, TimeUnit.SECONDS);
        logger.info("Avro source {} started.", (Object)this.getName());
    }

    @Override
    public void stop() {
        logger.info("Avro source {} stopping: {}", (Object)this.getName(), (Object)this);
        this.server.close();
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            logger.info("Avro source " + this.getName() + ": Interrupted while waiting " + "for Avro server to stop. Exiting. Exception follows.", (Throwable)e);
        }
        this.sourceCounter.stop();
        this.connectionCountUpdater.shutdown();
        while (!this.connectionCountUpdater.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                logger.error("Interrupted while waiting for connection count executor to terminate", (Throwable)ex);
                Throwables.propagate((Throwable)ex);
            }
        }
        super.stop();
        logger.info("Avro source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    @Override
    public String toString() {
        return "Avro source " + this.getName() + ": { bindAddress: " + this.bindAddress + ", port: " + this.port + " }";
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return stringMap;
    }

    public Status append(AvroFlumeEvent avroEvent) {
        logger.debug("Avro source {}: Received avro event: {}", (Object)this.getName(), (Object)avroEvent);
        this.sourceCounter.incrementAppendReceivedCount();
        this.sourceCounter.incrementEventReceivedCount();
        Event event = EventBuilder.withBody((byte[])avroEvent.getBody().array(), AvroSource.toStringMap(avroEvent.getHeaders()));
        try {
            this.getChannelProcessor().processEvent(event);
        }
        catch (ChannelException ex) {
            logger.warn("Avro source " + this.getName() + ": Unable to process event. " + "Exception follows.", (Throwable)ex);
            return Status.FAILED;
        }
        this.sourceCounter.incrementAppendAcceptedCount();
        this.sourceCounter.incrementEventAcceptedCount();
        return Status.OK;
    }

    public Status appendBatch(List<AvroFlumeEvent> events) {
        logger.debug("Avro source {}: Received avro event batch of {} events.", (Object)this.getName(), (Object)events.size());
        this.sourceCounter.incrementAppendBatchReceivedCount();
        this.sourceCounter.addToEventReceivedCount(events.size());
        ArrayList<Event> batch = new ArrayList<Event>();
        for (AvroFlumeEvent avroEvent : events) {
            Event event = EventBuilder.withBody((byte[])avroEvent.getBody().array(), AvroSource.toStringMap(avroEvent.getHeaders()));
            batch.add(event);
        }
        try {
            this.getChannelProcessor().processEventBatch(batch);
        }
        catch (Throwable t) {
            logger.error("Avro source " + this.getName() + ": Unable to process event " + "batch. Exception follows.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            return Status.FAILED;
        }
        this.sourceCounter.incrementAppendBatchAcceptedCount();
        this.sourceCounter.addToEventAcceptedCount(events.size());
        return Status.OK;
    }
}

