/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurableComponent;
import org.apache.flume.lifecycle.LifecycleState;

public class DefaultSinkProcessor
implements SinkProcessor,
ConfigurableComponent {
    private Sink sink;
    private LifecycleState lifecycleState;

    @Override
    public void start() {
        Preconditions.checkNotNull((Object)this.sink, (Object)"DefaultSinkProcessor sink not set");
        this.sink.start();
        this.lifecycleState = LifecycleState.START;
    }

    @Override
    public void stop() {
        Preconditions.checkNotNull((Object)this.sink, (Object)"DefaultSinkProcessor sink not set");
        this.sink.stop();
        this.lifecycleState = LifecycleState.STOP;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    public void configure(Context context) {
    }

    @Override
    public Sink.Status process() throws EventDeliveryException {
        return this.sink.process();
    }

    @Override
    public void setSinks(List<Sink> sinks) {
        Preconditions.checkNotNull(sinks);
        Preconditions.checkArgument((sinks.size() == 1 ? 1 : 0) != 0, (Object)"DefaultSinkPolicy can only handle one sink, try using a policy that supports multiple sinks");
        this.sink = sinks.get(0);
    }

    @Override
    public void configure(ComponentConfiguration conf) {
    }
}

