/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkFactory;
import org.apache.flume.conf.sink.SinkType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSinkFactory
implements SinkFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSinkFactory.class);
    private final Map<Class<?>, Map<String, Sink>> sinks = new HashMap();

    @Override
    public synchronized boolean unregister(Sink sink) {
        Preconditions.checkNotNull((Object)sink);
        boolean removed = false;
        logger.debug("Unregistering sink {}", (Object)sink);
        Map<String, Sink> sinkMap = this.sinks.get(sink.getClass());
        if (sinkMap != null) {
            boolean bl = removed = sinkMap.remove(sink.getName()) != null;
            if (sinkMap.size() == 0) {
                this.sinks.remove(sink.getClass());
            }
        }
        return removed;
    }

    @Override
    public Sink create(String name, String type) throws FlumeException {
        Sink sink;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        logger.info("Creating instance of sink: {}, type: {}", (Object)name, (Object)type);
        String sinkClassName = type;
        SinkType sinkType = SinkType.OTHER;
        try {
            sinkType = SinkType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Sink type {} is a custom type", (Object)type);
        }
        if (!sinkType.equals((Object)SinkType.OTHER)) {
            sinkClassName = sinkType.getSinkClassName();
        }
        Class<?> sinkClass = null;
        try {
            sinkClass = Class.forName(sinkClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load sink type: " + type + ", class: " + sinkClassName, (Throwable)ex);
        }
        Map<String, Sink> sinkMap = this.sinks.get(sinkClass);
        if (sinkMap == null) {
            sinkMap = new HashMap<String, Sink>();
            this.sinks.put(sinkClass, sinkMap);
        }
        if ((sink = sinkMap.get(name)) == null) {
            try {
                sink = (Sink)sinkClass.newInstance();
                sink.setName(name);
                sinkMap.put(name, sink);
            }
            catch (Exception ex) {
                this.sinks.remove(sinkClass);
                throw new FlumeException("Unable to create sink: " + name + ", type: " + type + ", class: " + sinkClassName, (Throwable)ex);
            }
        }
        return sink;
    }

    public synchronized Map<Class<?>, Map<String, Sink>> getRegistryClone() {
        HashMap result = new HashMap();
        for (Class<?> klass : this.sinks.keySet()) {
            Map<String, Sink> sinkMap = this.sinks.get(klass);
            HashMap<String, Sink> resultSinkMap = new HashMap<String, Sink>();
            resultSinkMap.putAll(sinkMap);
            result.put(klass, resultSinkMap);
        }
        return result;
    }
}

