/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.formatter.output;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flume.tools.TimestampRoundDownUtil;

public class BucketPath {
    public static final String TAG_REGEX = "\\%(\\w|\\%)|\\%\\{([\\w\\.-]+)\\}";
    public static final Pattern tagPattern = Pattern.compile("\\%(\\w|\\%)|\\%\\{([\\w\\.-]+)\\}");

    public static boolean containsTag(String in) {
        return tagPattern.matcher(in).find();
    }

    public static String expandShorthand(char c) {
        switch (c) {
            case 'a': {
                return "weekday_short";
            }
            case 'A': {
                return "weekday_full";
            }
            case 'b': {
                return "monthname_short";
            }
            case 'B': {
                return "monthname_full";
            }
            case 'c': {
                return "datetime";
            }
            case 'd': {
                return "day_of_month_xx";
            }
            case 'D': {
                return "date_short";
            }
            case 'H': {
                return "hour_24_xx";
            }
            case 'I': {
                return "hour_12_xx";
            }
            case 'j': {
                return "day_of_year_xxx";
            }
            case 'k': {
                return "hour_24";
            }
            case 'l': {
                return "hour_12";
            }
            case 'm': {
                return "month_xx";
            }
            case 'M': {
                return "minute_xx";
            }
            case 'p': {
                return "am_pm";
            }
            case 's': {
                return "unix_seconds";
            }
            case 'S': {
                return "seconds_xx";
            }
            case 't': {
                return "unix_millis";
            }
            case 'y': {
                return "year_xx";
            }
            case 'Y': {
                return "year_xxxx";
            }
            case 'z': {
                return "timezone_delta";
            }
        }
        return "" + c;
    }

    public static String replaceShorthand(char c, Map<String, String> headers) {
        return BucketPath.replaceShorthand(c, headers, false, 0, 0);
    }

    public static String replaceShorthand(char c, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        return BucketPath.replaceShorthand(c, headers, null, needRounding, unit, roundDown);
    }

    public static String replaceShorthand(char c, Map<String, String> headers, TimeZone timeZone, boolean needRounding, int unit, int roundDown) {
        long ts;
        String timestampHeader = headers.get("timestamp");
        try {
            ts = Long.valueOf(timestampHeader);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Flume wasn't able to parse timestamp header in the event to resolve time based bucketing. Please check that you're correctly populating timestamp header (for example using TimestampInterceptor source interceptor).", e);
        }
        if (needRounding) {
            ts = BucketPath.roundDown(roundDown, unit, ts);
        }
        String formatString = "";
        switch (c) {
            case '%': {
                return "%";
            }
            case 'a': {
                formatString = "EEE";
                break;
            }
            case 'A': {
                formatString = "EEEE";
                break;
            }
            case 'b': {
                formatString = "MMM";
                break;
            }
            case 'B': {
                formatString = "MMMM";
                break;
            }
            case 'c': {
                formatString = "EEE MMM d HH:mm:ss yyyy";
                break;
            }
            case 'd': {
                formatString = "dd";
                break;
            }
            case 'D': {
                formatString = "MM/dd/yy";
                break;
            }
            case 'H': {
                formatString = "HH";
                break;
            }
            case 'I': {
                formatString = "hh";
                break;
            }
            case 'j': {
                formatString = "DDD";
                break;
            }
            case 'k': {
                formatString = "H";
                break;
            }
            case 'l': {
                formatString = "h";
                break;
            }
            case 'm': {
                formatString = "MM";
                break;
            }
            case 'M': {
                formatString = "mm";
                break;
            }
            case 'p': {
                formatString = "a";
                break;
            }
            case 's': {
                return "" + ts / 1000L;
            }
            case 'S': {
                formatString = "ss";
                break;
            }
            case 't': {
                return timestampHeader;
            }
            case 'y': {
                formatString = "yy";
                break;
            }
            case 'Y': {
                formatString = "yyyy";
                break;
            }
            case 'z': {
                formatString = "ZZZ";
                break;
            }
            default: {
                return "";
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        Date date = new Date(ts);
        return format.format(date);
    }

    private static long roundDown(int roundDown, int unit, long ts) {
        long timestamp = ts;
        if (roundDown <= 0) {
            roundDown = 1;
        }
        switch (unit) {
            case 13: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampSeconds(ts, roundDown);
                break;
            }
            case 12: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampMinutes(ts, roundDown);
                break;
            }
            case 11: {
                timestamp = TimestampRoundDownUtil.roundDownTimeStampHours(ts, roundDown);
                break;
            }
            default: {
                timestamp = ts;
            }
        }
        return timestamp;
    }

    public static String escapeString(String in, Map<String, String> headers) {
        return BucketPath.escapeString(in, headers, false, 0, 0);
    }

    public static String escapeString(String in, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        return BucketPath.escapeString(in, headers, null, needRounding, unit, roundDown);
    }

    public static String escapeString(String in, Map<String, String> headers, TimeZone timeZone, boolean needRounding, int unit, int roundDown) {
        Matcher matcher = tagPattern.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = "";
            if (matcher.group(2) != null) {
                replacement = headers.get(matcher.group(2));
                if (replacement == null) {
                    replacement = "";
                }
            } else {
                Preconditions.checkState((matcher.group(1) != null && matcher.group(1).length() == 1 ? 1 : 0) != 0, (Object)("Expected to match single character tag in string " + in));
                char c = matcher.group(1).charAt(0);
                replacement = BucketPath.replaceShorthand(c, headers, timeZone, needRounding, unit, roundDown);
            }
            replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
            replacement = replacement.replaceAll("\\$", "\\\\\\$");
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> getEscapeMapping(String in, Map<String, String> headers) {
        return BucketPath.getEscapeMapping(in, headers, false, 0, 0);
    }

    public static Map<String, String> getEscapeMapping(String in, Map<String, String> headers, boolean needRounding, int unit, int roundDown) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Matcher matcher = tagPattern.matcher(in);
        while (matcher.find()) {
            String replacement = "";
            if (matcher.group(2) != null) {
                replacement = headers.get(matcher.group(2));
                if (replacement == null) {
                    replacement = "";
                }
                mapping.put(matcher.group(2), replacement);
                continue;
            }
            Preconditions.checkState((matcher.group(1) != null && matcher.group(1).length() == 1 ? 1 : 0) != 0, (Object)("Expected to match single character tag in string " + in));
            char c = matcher.group(1).charAt(0);
            replacement = BucketPath.replaceShorthand(c, headers, needRounding, unit, roundDown);
            mapping.put(BucketPath.expandShorthand(c), replacement);
        }
        return mapping;
    }
}

