/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.client.avro;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flume.FlumeException;
import org.apache.flume.client.avro.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoolingFileLineReader
implements LineReader {
    private static final Logger logger = LoggerFactory.getLogger(SpoolingFileLineReader.class);
    private static final int OVERFLOW_LINE_PRINT_CHARS = 30;
    private File directory;
    public String completedSuffix;
    private Optional<FileInfo> currentFile = Optional.absent();
    private Optional<FileInfo> lastFileRead = Optional.absent();
    private boolean committed = true;
    private int bufferMaxLines;
    private int bufferMaxLineLength;
    private boolean disabled = false;

    public SpoolingFileLineReader(File directory, String completedSuffix, int bufferMaxLines, int bufferMaxLineLength) {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkState((boolean)directory.exists(), (Object)("Directory does not exist: " + directory.getAbsolutePath()));
        Preconditions.checkState((boolean)directory.isDirectory(), (Object)("Path is not a directory: " + directory.getAbsolutePath()));
        Preconditions.checkState((bufferMaxLines > 0 ? 1 : 0) != 0);
        Preconditions.checkState((bufferMaxLineLength > 0 ? 1 : 0) != 0);
        try {
            File f1 = File.createTempFile("flume", "test", directory);
            Files.write((CharSequence)"testing flume file permissions\n", (File)f1, (Charset)Charsets.UTF_8);
            Files.readLines((File)f1, (Charset)Charsets.UTF_8);
            f1.delete();
        }
        catch (IOException e) {
            throw new FlumeException("Unable to read and modify files in the spooling directory: " + directory, (Throwable)e);
        }
        this.directory = directory;
        this.completedSuffix = completedSuffix;
        this.bufferMaxLines = bufferMaxLines;
        this.bufferMaxLineLength = bufferMaxLineLength;
    }

    public String getLastFileRead() {
        if (!this.lastFileRead.isPresent()) {
            return null;
        }
        return ((FileInfo)this.lastFileRead.get()).getFile().getAbsolutePath();
    }

    @Override
    public String readLine() throws IOException {
        if (this.disabled) {
            throw new IllegalStateException("Reader has been disabled.");
        }
        List<String> read = this.readLines(1);
        if (read.size() == 0) {
            return null;
        }
        return read.get(0);
    }

    public void commit() throws IOException {
        if (this.disabled) {
            throw new IllegalStateException("Reader has been disabled.");
        }
        ((FileInfo)this.currentFile.get()).reader.mark(this.bufferMaxLines * this.bufferMaxLineLength);
        this.committed = true;
    }

    @Override
    public List<String> readLines(int n) throws IOException {
        if (this.disabled) {
            throw new IllegalStateException("Reader has been disabled.");
        }
        if (!this.committed) {
            if (!this.currentFile.isPresent()) {
                throw new IllegalStateException("File should not roll when  commit is outstanding.");
            }
            logger.info("Last read was never comitted - resetting mark position.");
            ((FileInfo)this.currentFile.get()).getReader().reset();
        } else {
            if (!this.currentFile.isPresent()) {
                this.currentFile = this.getNextFile();
            }
            if (!this.currentFile.isPresent()) {
                return Collections.emptyList();
            }
        }
        String outLine = ((FileInfo)this.currentFile.get()).getReader().readLine();
        if (outLine == null) {
            this.retireCurrentFile();
            this.currentFile = this.getNextFile();
            if (!this.currentFile.isPresent()) {
                return Collections.emptyList();
            }
            outLine = ((FileInfo)this.currentFile.get()).getReader().readLine();
        }
        ArrayList out = Lists.newArrayList();
        while (outLine != null) {
            if (outLine.length() > this.bufferMaxLineLength) {
                logger.error("Found line longer than " + this.bufferMaxLineLength + " characters, cannot make progress.");
                int lastCharToPrint = Math.min(30, outLine.length());
                logger.error("Invalid line starts with: " + outLine.substring(0, lastCharToPrint));
                this.disabled = true;
                throw new FlumeException("Encoutered line that was too long.");
            }
            out.add(outLine);
            if (out.size() == n) break;
            outLine = ((FileInfo)this.currentFile.get()).getReader().readLine();
        }
        this.committed = false;
        this.lastFileRead = this.currentFile;
        return out;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void retireCurrentFile() throws IOException {
        Preconditions.checkState((boolean)this.currentFile.isPresent());
        String currPath = ((FileInfo)this.currentFile.get()).getFile().getAbsolutePath();
        String newPath = currPath + this.completedSuffix;
        logger.info("Preparing to move file " + currPath + " to " + newPath);
        ((FileInfo)this.currentFile.get()).reader.close();
        File newFile = new File(currPath);
        if (newFile.lastModified() != ((FileInfo)this.currentFile.get()).getLastModified()) {
            String message = "File has been modified since being read: " + currPath;
            throw new IllegalStateException(message);
        }
        if (newFile.length() != ((FileInfo)this.currentFile.get()).getLength()) {
            String message = "File has changed size since being read: " + currPath;
            throw new IllegalStateException(message);
        }
        File existing = new File(newPath);
        if (existing.exists() && System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            if (Files.equal((File)((FileInfo)this.currentFile.get()).getFile(), (File)existing)) {
                logger.warn("Completed file " + newPath + " already exists, but files match, so continuing.");
                boolean deleted = newFile.delete();
                if (deleted) return;
                logger.error("Unable to delete file " + newFile.getAbsolutePath() + ". It will likely be ingested another time.");
                return;
            }
            String message = "File name has been re-used with different files. Spooling assumption violated for " + newPath;
            throw new IllegalStateException(message);
        }
        if (existing.exists()) {
            String message = "File name has been re-used with different files. Spooling assumption violated for " + newPath;
            throw new IllegalStateException(message);
        }
        boolean renamed = newFile.renameTo(new File(newPath));
        if (renamed) return;
        String message = "Unable to move " + currPath + " to " + newPath + ". This will likely cause duplicate events. Please verify that " + "flume has sufficient permissions to perform these operations.";
        throw new FlumeException(message);
    }

    private Optional<FileInfo> getNextFile() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return !pathName.getName().endsWith(SpoolingFileLineReader.this.completedSuffix) && !pathName.getName().startsWith(".");
            }
        };
        List<File> candidateFiles = Arrays.asList(this.directory.listFiles(filter));
        if (candidateFiles.isEmpty()) {
            return Optional.absent();
        }
        Collections.sort(candidateFiles, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                int timeComparison = new Long(a.lastModified()).compareTo(new Long(b.lastModified()));
                if (timeComparison != 0) {
                    return timeComparison;
                }
                return a.getName().compareTo(b.getName());
            }
        });
        File nextFile = candidateFiles.get(0);
        try {
            int bufferSize = this.bufferMaxLines * this.bufferMaxLineLength;
            BufferedReader reader = new BufferedReader(new FileReader(nextFile), bufferSize);
            reader.mark(bufferSize);
            return Optional.of((Object)new FileInfo(nextFile, reader));
        }
        catch (FileNotFoundException e) {
            logger.warn("Could not find file: " + nextFile, (Throwable)e);
            return Optional.absent();
        }
        catch (IOException e) {
            logger.error("Exception opening file: " + nextFile, (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    public void close() throws IOException {
    }

    private class FileInfo {
        private File file;
        private long length;
        private long lastModified;
        private BufferedReader reader;

        public FileInfo(File file, BufferedReader reader) {
            this.file = file;
            this.length = file.length();
            this.lastModified = file.lastModified();
            this.reader = reader;
        }

        public long getLength() {
            return this.length;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public BufferedReader getReader() {
            return this.reader;
        }

        public File getFile() {
            return this.file;
        }
    }
}

