/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelFactory;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.channel.ChannelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelFactory
implements ChannelFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChannelFactory.class);
    private Map<Class<?>, Map<String, Channel>> channels = new HashMap();

    @Override
    public boolean unregister(Channel channel) {
        Preconditions.checkNotNull((Object)channel);
        logger.info("Unregister channel {}", (Object)channel);
        boolean removed = false;
        Map<String, Channel> channelMap = this.channels.get(channel.getClass());
        if (channelMap != null) {
            boolean bl = removed = channelMap.remove(channel.getName()) != null;
            if (channelMap.size() == 0) {
                this.channels.remove(channel.getClass());
            }
        }
        return removed;
    }

    @Override
    public Channel create(String name, String type) throws FlumeException {
        Channel channel;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        logger.debug("Creating instance of channel {} type {}", (Object)name, (Object)type);
        String channelClassName = type;
        ChannelType channelType = ChannelType.OTHER;
        try {
            channelType = ChannelType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Channel type {} is a custom type", (Object)type);
        }
        if (!channelType.equals((Object)ChannelType.OTHER)) {
            channelClassName = channelType.getChannelClassName();
        }
        Class<?> channelClass = null;
        try {
            channelClass = Class.forName(channelClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load channel type: " + type + ", class: " + channelClassName, (Throwable)ex);
        }
        Map<String, Channel> channelMap = this.channels.get(channelClass);
        if (channelMap == null) {
            channelMap = new HashMap<String, Channel>();
            this.channels.put(channelClass, channelMap);
        }
        if ((channel = channelMap.get(name)) == null) {
            try {
                channel = (Channel)channelClass.newInstance();
                channel.setName(name);
                channelMap.put(name, channel);
            }
            catch (Exception ex) {
                this.channels.remove(channelClass);
                throw new FlumeException("Unable to create channel: " + name + ", type: " + type + ", class: " + channelClassName, (Throwable)ex);
            }
        }
        return channel;
    }

    public Map<Class<?>, Map<String, Channel>> getRegistryClone() {
        HashMap result = new HashMap();
        for (Class<?> klass : this.channels.keySet()) {
            Map<String, Channel> channelMap = this.channels.get(klass);
            HashMap<String, Channel> resultChannelMap = new HashMap<String, Channel>();
            resultChannelMap.putAll(channelMap);
            result.put(klass, resultChannelMap);
        }
        return result;
    }
}

