/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.clients.log4jappender;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.clients.log4jappender.Log4jAvroHeaders;
import org.apache.flume.event.EventBuilder;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jAppender
extends AppenderSkeleton {
    private String hostname;
    private int port;
    private RpcClient rpcClient = null;

    public Log4jAppender() {
    }

    public Log4jAppender(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized void append(LoggingEvent event) throws FlumeException {
        if (this.rpcClient == null) {
            throw new FlumeException("Cannot Append to Appender!Appender either closed or not setup correctly!");
        }
        if (!this.rpcClient.isActive()) {
            this.reconnect();
        }
        HashMap<String, String> hdrs = new HashMap<String, String>();
        hdrs.put(Log4jAvroHeaders.LOGGER_NAME.toString(), event.getLoggerName());
        hdrs.put(Log4jAvroHeaders.TIMESTAMP.toString(), String.valueOf(event.getTimeStamp()));
        hdrs.put(Log4jAvroHeaders.LOG_LEVEL.toString(), String.valueOf(event.getLevel().toInt()));
        hdrs.put(Log4jAvroHeaders.MESSAGE_ENCODING.toString(), "UTF8");
        Event flumeEvent = EventBuilder.withBody((String)event.getMessage().toString(), (Charset)Charset.forName("UTF8"), hdrs);
        try {
            this.rpcClient.append(flumeEvent);
        }
        catch (EventDeliveryException e) {
            String msg = "Flume append() failed.";
            LogLog.error((String)msg);
            throw new FlumeException(msg + " Exception follows.", (Throwable)e);
        }
    }

    public synchronized void close() throws FlumeException {
        if (this.rpcClient != null) {
            this.rpcClient.close();
            this.rpcClient = null;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void activateOptions() throws FlumeException {
        try {
            this.rpcClient = RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port);
        }
        catch (FlumeException e) {
            String errormsg = "RPC client creation failed! " + e.getMessage();
            LogLog.error((String)errormsg);
            throw e;
        }
    }

    private void reconnect() throws FlumeException {
        this.close();
        this.activateOptions();
    }
}

