/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.RegionInfo;
import org.hbase.async.UnknownScannerException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    public static final int DEFAULT_MAX_NUM_KVS = 4096;
    public static final int DEFAULT_MAX_NUM_ROWS = 128;
    private static final RegionInfo DONE = new RegionInfo(HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY);
    private final HBaseClient client;
    private final byte[] table;
    private byte[] start_key = HBaseClient.EMPTY_ARRAY;
    private byte[] stop_key = HBaseClient.EMPTY_ARRAY;
    private byte[] family;
    private byte[] qualifier;
    private byte[] filter;
    private boolean populate_blockcache = true;
    private int max_num_rows = 128;
    private int max_num_kvs = 4096;
    private RegionInfo region;
    private long scanner_id;
    private GetNextRowsRequest get_next_rows_request;
    private static final byte[] ROWFILTER = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RowFilter");
    private static final byte[] REGEXSTRINGCOMPARATOR = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private static final byte[] EQUAL = new byte[]{69, 81, 85, 65, 76};
    private final Callback<Object, Object> got_next_row = new Callback<Object, Object>(){

        public Object call(Object response) {
            if (response == null) {
                byte[] region_stop_key = Scanner.this.region.stopKey();
                if (region_stop_key == HBaseClient.EMPTY_ARRAY || Scanner.this.stop_key != HBaseClient.EMPTY_ARRAY && Bytes.memcmp(Scanner.this.stop_key, region_stop_key) <= 0) {
                    Scanner.this.get_next_rows_request = null;
                    Scanner.access$502(Scanner.this, Scanner.access$602(Scanner.this, null));
                    Scanner.access$702(Scanner.this, Scanner.access$302(Scanner.this, HBaseClient.EMPTY_ARRAY));
                    return Scanner.this.close().addCallback((Callback)new Callback<ArrayList<ArrayList<KeyValue>>, Object>(){

                        public ArrayList<ArrayList<KeyValue>> call(Object arg) {
                            return null;
                        }

                        public String toString() {
                            return "auto-close scanner " + Bytes.hex(Scanner.this.scanner_id);
                        }
                    });
                }
                return Scanner.this.continueScanOnNextRegion();
            }
            if (!(response instanceof ArrayList)) {
                throw new InvalidResponseException(ArrayList.class, response);
            }
            ArrayList rows = (ArrayList)response;
            ArrayList lastrow = (ArrayList)rows.get(rows.size() - 1);
            Scanner.access$702(Scanner.this, ((KeyValue)lastrow.get(0)).key());
            return rows;
        }

        public String toString() {
            return "get nextRows response";
        }
    };
    private static final byte[] OPEN_SCANNER = new byte[]{111, 112, 101, 110, 83, 99, 97, 110, 110, 101, 114};
    private static final byte[] NEXT = new byte[]{110, 101, 120, 116};

    Scanner(HBaseClient client, byte[] table) {
        KeyValue.checkTable(table);
        this.client = client;
        this.table = table;
    }

    public byte[] getCurrentKey() {
        return this.start_key;
    }

    public void setStartKey(byte[] start_key) {
        KeyValue.checkKey(start_key);
        this.checkScanningNotStarted();
        this.start_key = start_key;
    }

    public void setStartKey(String start_key) {
        this.setStartKey(start_key.getBytes());
    }

    public void setStopKey(byte[] stop_key) {
        KeyValue.checkKey(stop_key);
        this.checkScanningNotStarted();
        this.stop_key = stop_key;
    }

    public void setStopKey(String stop_key) {
        this.setStopKey(stop_key.getBytes());
    }

    public void setFamily(byte[] family) {
        KeyValue.checkFamily(family);
        this.checkScanningNotStarted();
        this.family = family;
    }

    public void setFamily(String family) {
        this.setFamily(family.getBytes());
    }

    public void setQualifier(byte[] qualifier) {
        KeyValue.checkQualifier(qualifier);
        this.checkScanningNotStarted();
        this.qualifier = qualifier;
    }

    public void setQualifier(String qualifier) {
        this.setQualifier(qualifier.getBytes());
    }

    public void setKeyRegexp(String regexp) {
        this.setKeyRegexp(regexp, CharsetUtil.ISO_8859_1);
    }

    public void setKeyRegexp(String regexp, Charset charset) {
        byte[] regex = Bytes.UTF8(regexp);
        byte[] chars = Bytes.UTF8(charset.name());
        this.filter = new byte[105 + regex.length + 2 + chars.length];
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((byte[])this.filter);
        buf.clear();
        buf.writeByte((int)((byte)ROWFILTER.length));
        buf.writeBytes(ROWFILTER);
        buf.writeShort(5);
        buf.writeBytes(EQUAL);
        buf.writeByte(53);
        buf.writeByte(0);
        buf.writeByte((int)((byte)REGEXSTRINGCOMPARATOR.length));
        buf.writeBytes(REGEXSTRINGCOMPARATOR);
        buf.writeShort(regex.length);
        buf.writeBytes(regex);
        buf.writeShort(chars.length);
        buf.writeBytes(chars);
    }

    public void setServerBlockCache(boolean populate_blockcache) {
        this.checkScanningNotStarted();
        this.populate_blockcache = populate_blockcache;
    }

    public void setMaxNumRows(int max_num_rows) {
        if (max_num_rows <= 0) {
            throw new IllegalArgumentException("zero or negative argument: " + max_num_rows);
        }
        this.max_num_rows = max_num_rows;
    }

    public void setMaxNumKeyValues(int max_num_kvs) {
        if (max_num_kvs == 0) {
            throw new IllegalArgumentException("batch size can't be zero");
        }
        this.checkScanningNotStarted();
        this.max_num_kvs = max_num_kvs;
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows(int nrows) {
        this.setMaxNumRows(nrows);
        return this.nextRows();
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows() {
        if (this.region == DONE) {
            return Deferred.fromResult(null);
        }
        if (this.region == null) {
            return this.client.openScanner(this).addCallbackDeferring((Callback)new Callback<Deferred<ArrayList<ArrayList<KeyValue>>>, Long>(){

                public Deferred<ArrayList<ArrayList<KeyValue>>> call(Long arg) {
                    Scanner.this.scanner_id = arg;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanner " + Bytes.hex(arg) + " opened on " + Scanner.this.region);
                    }
                    return Scanner.this.nextRows();
                }

                public String toString() {
                    return "scanner opened";
                }
            });
        }
        Deferred d = this.client.scanNextRows(this).addCallbacks(this.got_next_row, this.nextRowErrback());
        return d;
    }

    private final Callback<Object, Object> nextRowErrback() {
        return new Callback<Object, Object>(){

            public Object call(Object error) {
                RegionInfo old_region = Scanner.this.region;
                Scanner.this.invalidate();
                if (error instanceof NotServingRegionException) {
                    Scanner.access$702(Scanner.this, Arrays.copyOf(Scanner.this.start_key, Scanner.this.start_key.length + 1));
                    return Scanner.this.nextRows();
                }
                if (error instanceof UnknownScannerException) {
                    Scanner scnr = Scanner.this;
                    LOG.warn(old_region + " pretends to not know " + scnr + ".  I will" + " retry to open a scanner but this is typically because you've" + " been holding the scanner open and idle for too long (possibly" + " due to a long GC pause on your side or in the RegionServer)", error);
                    return Scanner.this.nextRows();
                }
                return error;
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    public Deferred<Object> close() {
        if (this.region == null || this.region == DONE) {
            return Deferred.fromResult(null);
        }
        return this.client.closeScanner(this).addBoth(this.closedCallback());
    }

    private Callback<Object, Object> closedCallback() {
        return new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (arg instanceof Exception) {
                    Exception error = (Exception)arg;
                    if (error instanceof NotServingRegionException || error instanceof UnknownScannerException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring exception when closing " + Scanner.this, (Throwable)error);
                        }
                        arg = null;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(Scanner.this.scanner_id) + " closed on " + Scanner.this.region);
                }
                Scanner.this.region = DONE;
                Scanner.this.scanner_id = -2401262971557716307L;
                return arg;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    private Deferred<ArrayList<ArrayList<KeyValue>>> continueScanOnNextRegion() {
        final long old_scanner_id = this.scanner_id;
        final RegionInfo old_region = this.region;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " done scanning " + old_region);
        }
        this.client.closeScanner(this).addCallback((Callback)new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " closed on " + old_region);
                }
                return arg;
            }

            public String toString() {
                return "scanner moved";
            }
        });
        this.start_key = this.region.stopKey();
        this.scanner_id = -2401262980684521811L;
        this.invalidate();
        return this.nextRows();
    }

    public String toString() {
        String region = this.region == null ? "null" : (this.region == DONE ? "none" : this.region.toString());
        StringBuilder buf = new StringBuilder(15 + this.table.length + 1 + 12 + 1 + this.start_key.length + 1 + 1 + this.stop_key.length + 1 + 9 + 1 + (this.family == null ? 4 : this.family.length) + 1 + 12 + 1 + (this.qualifier == null ? 4 : this.qualifier.length) + 1 + 22 + 5 + 15 + 5 + 14 + 6 + 14 + 1 + region.length() + 1 + 13 + 18 + 1);
        buf.append("Scanner(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", start_key=");
        Bytes.pretty(buf, this.start_key);
        buf.append(", stop_key=");
        Bytes.pretty(buf, this.stop_key);
        buf.append(", family=");
        Bytes.pretty(buf, this.family);
        buf.append(", qualifier=");
        Bytes.pretty(buf, this.qualifier);
        buf.append(", populate_blockcache=").append(this.populate_blockcache).append(", max_num_rows=").append(this.max_num_rows).append(", max_num_kvs=").append(this.max_num_kvs).append(", region=").append(region);
        buf.append(", scanner_id=").append(Bytes.hex(this.scanner_id)).append(')');
        return buf.toString();
    }

    byte[] table() {
        return this.table;
    }

    byte[] startKey() {
        return this.start_key;
    }

    void setRegionName(RegionInfo region) {
        this.region = region;
    }

    void invalidate() {
        this.region = null;
    }

    RegionInfo currentRegion() {
        return this.region;
    }

    HBaseRpc getNextRowsRequest() {
        if (this.get_next_rows_request == null) {
            this.get_next_rows_request = new GetNextRowsRequest();
        }
        return this.get_next_rows_request;
    }

    HBaseRpc getOpenRequest() {
        return new OpenScannerRequest();
    }

    HBaseRpc getCloseRequest() {
        return new CloseScannerRequest(this.scanner_id);
    }

    private void checkScanningNotStarted() {
        if (this.region != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    static /* synthetic */ byte[] access$502(Scanner x0, byte[] x1) {
        x0.family = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$602(Scanner x0, byte[] x1) {
        x0.qualifier = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(Scanner x0, byte[] x1) {
        x0.start_key = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(Scanner x0, byte[] x1) {
        x0.stop_key = x1;
        return x1;
    }

    private static final class CloseScannerRequest
    extends HBaseRpc {
        private static final byte[] CLOSE = new byte[]{99, 108, 111, 115, 101};
        private final long scanner_id;

        public CloseScannerRequest(long scanner_id) {
            super(CLOSE);
            this.scanner_id = scanner_id;
        }

        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 13);
            buf.writeInt(1);
            CloseScannerRequest.writeHBaseLong(buf, this.scanner_id);
            return buf;
        }

        public String toString() {
            return "CloseScannerRequest(scanner_id=" + this.scanner_id + ", attempt=" + this.attempt + ')';
        }
    }

    private final class GetNextRowsRequest
    extends HBaseRpc {
        public GetNextRowsRequest() {
            super(NEXT);
        }

        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 18);
            buf.writeInt(2);
            GetNextRowsRequest.writeHBaseLong(buf, Scanner.this.scanner_id);
            GetNextRowsRequest.writeHBaseInt(buf, Scanner.this.max_num_rows);
            return buf;
        }

        public String toString() {
            return "GetNextRowsRequest(scanner_id=" + Scanner.this.scanner_id + ", max_num_rows=" + Scanner.this.max_num_rows + ", region=" + this.region + ", attempt=" + this.attempt + ')';
        }
    }

    private final class OpenScannerRequest
    extends HBaseRpc {
        public OpenScannerRequest() {
            super(OPEN_SCANNER, Scanner.this.table, Scanner.this.start_key);
        }

        private int predictSerializedSize() {
            int size = 0;
            size += 4;
            ++size;
            size += 3;
            size += this.region.name().length;
            ++size;
            ++size;
            ++size;
            size += 3;
            size += Scanner.this.start_key.length;
            size += 3;
            size += Scanner.this.stop_key.length;
            size += 4;
            size += 4;
            size += 4;
            ++size;
            ++size;
            if (Scanner.this.filter != null) {
                size += Scanner.this.filter.length;
            }
            size += 8;
            size += 8;
            ++size;
            size += 4;
            if (Scanner.this.family != null) {
                ++size;
                size += Scanner.this.family.length;
                size += 4;
                if (Scanner.this.qualifier != null) {
                    size += 3;
                    size += Scanner.this.qualifier.length;
                }
            }
            return size;
        }

        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
            buf.writeInt(2);
            OpenScannerRequest.writeHBaseByteArray(buf, this.region.name());
            buf.writeByte(39);
            buf.writeByte(39);
            buf.writeByte(1);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.start_key);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.stop_key);
            buf.writeInt(1);
            buf.writeInt(Scanner.this.max_num_kvs);
            buf.writeInt(-559039906);
            buf.writeByte(Scanner.this.populate_blockcache ? 1 : 0);
            if (Scanner.this.filter == null) {
                buf.writeByte(0);
            } else {
                buf.writeByte(1);
                buf.writeBytes(Scanner.this.filter);
            }
            buf.writeLong(0L);
            buf.writeLong(Long.MAX_VALUE);
            buf.writeByte(1);
            buf.writeInt(Scanner.this.family != null ? 1 : 0);
            if (Scanner.this.family != null) {
                OpenScannerRequest.writeByteArray(buf, Scanner.this.family);
                buf.writeInt(Scanner.this.qualifier == null ? 0 : 1);
                if (Scanner.this.qualifier != null) {
                    OpenScannerRequest.writeByteArray(buf, Scanner.this.qualifier);
                }
            }
            Scanner.this.region = this.region;
            return buf;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(12 + Scanner.this.start_key.length + 2 + 11 + Scanner.this.stop_key.length + 2 + 14 + 4 + 22 + 5);
            buf.append(", start_key=");
            Bytes.pretty(buf, Scanner.this.start_key);
            buf.append(", stop_key=");
            Bytes.pretty(buf, Scanner.this.stop_key);
            buf.append(", max_num_kvs=").append(Scanner.this.max_num_kvs).append(", populate_blockcache=").append(Scanner.this.populate_blockcache);
            return super.toStringWithQualifier("OpenScannerRequest", Scanner.this.family, Scanner.this.qualifier, buf.toString());
        }
    }
}

