/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.HasFailedRpcException;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClient;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiAction
extends HBaseRpc {
    private static final byte[] MULTI_PUT = new byte[]{109, 117, 108, 116, 105, 80, 117, 116};
    private static final byte[] MULTI = new byte[]{109, 117, 108, 116, 105};
    private static final NotServingRegionException NSRE = new NotServingRegionException("Region unavailable", null);
    static final byte USE_MULTI = 29;
    private final ArrayList<BatchableRpc> batch = new ArrayList();
    static final MultiActionComparator MULTI_CMP = new MultiActionComparator();
    private static final MultiActionSuccess SUCCESS = new MultiActionSuccess();

    public MultiAction(byte server_version) {
        super(server_version >= 29 ? MULTI : MULTI_PUT);
    }

    public int size() {
        return this.batch.size();
    }

    public void add(BatchableRpc rpc) {
        if (rpc.lockid != -1L) {
            throw new AssertionError((Object)("Should never happen!  We don't do multi-put with RowLocks but we've been given an edit that has one!  edit=" + rpc + ", this=" + this));
        }
        this.batch.add(rpc);
    }

    ArrayList<BatchableRpc> batch() {
        return this.batch;
    }

    private int predictSerializedSize(byte server_version) {
        int size = 0;
        size += 4;
        ++size;
        ++size;
        size += 4;
        boolean use_multi = this.method() == MULTI;
        BatchableRpc prev = PutRequest.EMPTY_PUT;
        for (BatchableRpc rpc : this.batch) {
            boolean new_family;
            byte[] region_name = rpc.getRegion().name();
            boolean new_region = !Bytes.equals(prev.getRegion().name(), region_name);
            byte[] family = rpc.family();
            boolean new_key = new_region || ((BatchableRpc)prev).code() != rpc.code() || !Bytes.equals(prev.key, rpc.key) || family == DeleteRequest.WHOLE_ROW;
            boolean bl = new_family = new_key || !Bytes.equals(prev.family(), family);
            if (new_region) {
                size += 3;
                size += region_name.length;
                size += 4;
            }
            int key_length = rpc.key.length;
            if (new_key) {
                if (use_multi) {
                    size += 4;
                    size += 4;
                    size += 3;
                    ++size;
                    ++size;
                    ++size;
                    ++size;
                }
                ++size;
                size += 3;
                size += key_length;
                size += 8;
                size += 8;
                ++size;
                size += 4;
            }
            if (new_family) {
                ++size;
                size += family.length;
                size += 4;
                if (rpc.code() == 35) {
                    size += 4;
                }
            }
            size += rpc.payloadSize();
            prev = rpc;
        }
        return size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        Collections.sort(this.batch, MULTI_CMP);
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize(server_version));
        buf.writeInt(1);
        boolean use_multi = this.method() == MULTI;
        int code = use_multi ? 66 : 57;
        buf.writeByte(code);
        buf.writeByte(code);
        buf.writeInt(0);
        int nregions = 0;
        int nkeys_index = -1;
        int nkeys = 0;
        int nfamilies_index = -1;
        int nfamilies = 0;
        int nkeys_per_family_index = -1;
        int nkeys_per_family = 0;
        int nbytes_per_family = 0;
        int nrpcs_per_key = 0;
        BatchableRpc prev = PutRequest.EMPTY_PUT;
        for (BatchableRpc rpc : this.batch) {
            boolean new_family;
            byte[] region_name = rpc.getRegion().name();
            boolean new_region = !Bytes.equals(prev.getRegion().name(), region_name);
            byte[] family = rpc.family();
            boolean new_key = new_region || ((BatchableRpc)prev).code() != rpc.code() || !Bytes.equals(prev.key, rpc.key) || family == DeleteRequest.WHOLE_ROW;
            boolean bl = new_family = new_key || !Bytes.equals(prev.family(), family);
            if (new_key && use_multi && nkeys_index > 0) {
                buf.writeInt(0);
                buf.writeInt(nrpcs_per_key);
                nrpcs_per_key = 0;
                MultiAction.writeHBaseNull(buf);
            }
            if (new_region) {
                if (nkeys_index > 0) {
                    buf.setInt(nkeys_index, nkeys);
                    nkeys = 0;
                }
                ++nregions;
                MultiAction.writeByteArray(buf, region_name);
                nkeys_index = buf.writerIndex();
                buf.writeInt(0);
            }
            byte[] key = rpc.key;
            if (new_key) {
                if (nfamilies_index > 0) {
                    buf.setInt(nfamilies_index, nfamilies);
                    nfamilies = 0;
                }
                if (use_multi) {
                    buf.writeByte(65);
                    buf.writeByte(65);
                    buf.writeByte(64);
                    buf.writeByte((int)rpc.code());
                }
                ++nkeys;
                buf.writeByte((int)rpc.version(server_version));
                MultiAction.writeByteArray(buf, key);
                buf.writeLong(rpc.timestamp);
                buf.writeLong(-1L);
                buf.writeByte(rpc.durable ? 1 : 0);
                nfamilies_index = buf.writerIndex();
                buf.writeInt(0);
            }
            if (new_family) {
                if (nkeys_per_family_index > 0) {
                    buf.setInt(nkeys_per_family_index, nkeys_per_family);
                    if (((BatchableRpc)prev).code() == 35) {
                        buf.setInt(nkeys_per_family_index + 4, nbytes_per_family);
                    }
                    nkeys_per_family = 0;
                    nbytes_per_family = 0;
                }
                if (family == DeleteRequest.WHOLE_ROW) {
                    prev = rpc;
                    continue;
                }
                ++nfamilies;
                MultiAction.writeByteArray(buf, family);
                nkeys_per_family_index = buf.writerIndex();
                buf.writeInt(0);
                if (rpc.code() == 35) {
                    buf.writeInt(0);
                }
            }
            nkeys_per_family += rpc.numKeyValues();
            ++nrpcs_per_key;
            nbytes_per_family += rpc.payloadSize();
            rpc.serializePayload(buf);
            prev = rpc;
        }
        if (use_multi) {
            buf.writeInt(0);
            buf.writeInt(nrpcs_per_key);
            MultiAction.writeHBaseNull(buf);
        }
        if (nkeys_per_family_index > 0) {
            buf.setInt(nkeys_per_family_index, nkeys_per_family);
            if (((BatchableRpc)prev).code() == 35) {
                buf.setInt(nkeys_per_family_index + 4, nbytes_per_family);
            }
        }
        buf.setInt(nfamilies_index, nfamilies);
        buf.setInt(nkeys_index, nkeys);
        int header_length = 10 + this.method().length;
        if (server_version >= 29) {
            header_length += 13;
        }
        buf.setInt(header_length + 4 + 1 + 1, nregions);
        return buf;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("MultiAction(batch=[");
        int nrpcs = this.batch.size();
        for (i = 0; i < nrpcs && buf.length() < 1024; ++i) {
            buf.append(this.batch.get(i)).append(", ");
        }
        if (i < nrpcs) {
            if (i == nrpcs - 1) {
                buf.append("... 1 RPC not shown])");
            } else {
                buf.append("... ").append(nrpcs - 1 - i).append(" RPCs not shown ..., ").append(this.batch.get(nrpcs - 1)).append("])");
            }
        } else {
            buf.setLength(buf.length() - 2);
            buf.append("])");
        }
        return buf.toString();
    }

    Response responseFromBuffer(ChannelBuffer buf) {
        switch (buf.readByte()) {
            case 58: {
                return this.deserializeMultiPutResponse(buf);
            }
            case 67: {
                return this.deserializeMultiResponse(buf);
            }
        }
        throw new NonRecoverableException("Couldn't de-serialize " + Bytes.pretty(buf));
    }

    Response deserializeMultiResponse(ChannelBuffer buf) {
        int nregions = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, nregions);
        Object[] resps = new Object[this.batch.size()];
        int n = 0;
        for (int i = 0; i < nregions; ++i) {
            byte[] region_name = HBaseRpc.readByteArray(buf);
            int nkeys = buf.readInt();
            HBaseRpc.checkNonEmptyArrayLength(buf, nkeys);
            for (int j = 0; j < nkeys; ++j) {
                Object resp;
                HBaseException e;
                boolean error;
                int nrpcs_per_key = buf.readInt();
                boolean bl = error = buf.readByte() != 0;
                if (error) {
                    e = RegionClient.deserializeException(buf, null);
                    resp = e;
                } else {
                    resp = RegionClient.deserializeObject(buf, this);
                    if (resp instanceof ArrayList && ((ArrayList)resp).isEmpty()) {
                        resp = SUCCESS;
                    } else if (resp == null) {
                        resp = NSRE;
                        error = true;
                    }
                }
                if (error) {
                    e = (HBaseException)resp;
                    for (int k = 0; k < nrpcs_per_key; ++k) {
                        resps[n + k] = e.make(e.getMessage(), this.batch.get(n + k));
                    }
                } else {
                    for (int k = 0; k < nrpcs_per_key; ++k) {
                        resps[n + k] = resp;
                    }
                }
                n += nrpcs_per_key;
            }
        }
        return new Response(resps);
    }

    Response deserializeMultiPutResponse(ChannelBuffer buf) {
        int nregions = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, nregions);
        int nrpcs = this.batch.size();
        Object[] resps = new Object[nrpcs];
        int n = 0;
        for (int i = 0; i < nregions; ++i) {
            int j;
            int edits_per_region;
            byte[] region_name = HBaseRpc.readByteArray(buf);
            assert (Bytes.equals(region_name, this.batch.get(n).getRegion().name())) : "WTF?  " + Bytes.pretty(region_name) + " != " + this.batch.get(n).getRegion().name();
            int failed = buf.readInt();
            for (edits_per_region = n; edits_per_region < nrpcs && Bytes.equals(region_name, this.batch.get(edits_per_region).getRegion().name()); ++edits_per_region) {
            }
            assert (failed < (edits_per_region -= n)) : "WTF? Found more failed RPCs " + failed + " than sent " + edits_per_region + " to " + Bytes.pretty(region_name);
            if (failed == -1) {
                for (j = 0; j < edits_per_region; ++j) {
                    resps[n + j] = SUCCESS;
                }
            } else {
                assert (failed >= 0) : "WTF?  Found a negative failure index " + failed + " for region " + Bytes.pretty(region_name);
                for (j = 0; j < failed; ++j) {
                    resps[n + j] = SUCCESS;
                }
                String msg = "Multi-put failed on RPC #" + failed + "/" + edits_per_region + " on region " + Bytes.pretty(region_name);
                for (int j2 = failed; j2 < edits_per_region; ++j2) {
                    resps[n + j2] = new MultiPutFailedException(msg, this.batch.get(n + j2));
                }
            }
            n += edits_per_region;
        }
        return new Response(resps);
    }

    private static final class MultiActionSuccess {
        private MultiActionSuccess() {
        }

        public String toString() {
            return "MultiActionSuccess";
        }
    }

    private final class MultiPutFailedException
    extends RecoverableException
    implements HasFailedRpcException {
        final HBaseRpc failed_rpc;
        private static final long serialVersionUID = 1326900942L;

        MultiPutFailedException(String msg, HBaseRpc failed_rpc) {
            super(msg);
            this.failed_rpc = failed_rpc;
        }

        public String getMessage() {
            return super.getMessage() + "\nCaused by RPC: " + this.failed_rpc;
        }

        public HBaseRpc getFailedRpc() {
            return this.failed_rpc;
        }

        MultiPutFailedException make(Object msg, HBaseRpc rpc) {
            return new MultiPutFailedException(msg.toString(), rpc);
        }
    }

    final class Response {
        private final Object[] resps;

        Response(Object[] resps) {
            assert (resps.length == MultiAction.this.batch.size()) : "Got " + resps.length + " responses but expected " + MultiAction.access$100(multiAction).size();
            this.resps = resps;
        }

        public Object result(int i) {
            return this.resps[i];
        }

        public String toString() {
            return "MultiAction.Response(" + Arrays.toString(this.resps) + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultiActionComparator
    implements Comparator<BatchableRpc> {
        private MultiActionComparator() {
        }

        @Override
        public int compare(BatchableRpc a, BatchableRpc b) {
            int d = Bytes.memcmp(a.getRegion().name(), b.getRegion().name());
            if (d != 0) {
                return d;
            }
            d = a.code() - b.code();
            if (d != 0) {
                return d;
            }
            d = Bytes.memcmp(a.key, b.key);
            if (d != 0) {
                return d;
            }
            return Bytes.memcmp(a.family(), b.family());
        }
    }
}

