/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class GetRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers {
    private static final byte[] GET = new byte[]{103, 101, 116};
    private static final byte[] EXISTS = new byte[]{101, 120, 105, 115, 116, 115};
    private byte[] family;
    private byte[][] qualifiers;
    private long lockid = -1L;

    public GetRequest(byte[] table, byte[] key) {
        super(GET, table, key);
    }

    public GetRequest(String table, byte[] key) {
        this(table.getBytes(), key);
    }

    public GetRequest(String table, String key) {
        this(table.getBytes(), key.getBytes());
    }

    private GetRequest(float unused, byte[] table, byte[] key) {
        super(EXISTS, table, key);
    }

    static HBaseRpc exists(byte[] table, byte[] key) {
        return new GetRequest(0.0f, table, key);
    }

    public GetRequest family(byte[] family) {
        KeyValue.checkFamily(family);
        this.family = family;
        return this;
    }

    public GetRequest family(String family) {
        return this.family(family.getBytes());
    }

    public GetRequest qualifier(byte[] qualifier) {
        if (qualifier == null) {
            throw new NullPointerException("qualifier");
        }
        KeyValue.checkQualifier(qualifier);
        this.qualifiers = new byte[][]{qualifier};
        return this;
    }

    public GetRequest qualifiers(byte[][] qualifiers) {
        if (qualifiers == null) {
            throw new NullPointerException("qualifiers");
        }
        for (byte[] qualifier : qualifiers) {
            KeyValue.checkQualifier(qualifier);
        }
        this.qualifiers = qualifiers;
        return this;
    }

    public GetRequest qualifier(String qualifier) {
        return this.qualifier(qualifier.getBytes());
    }

    public GetRequest withRowLock(RowLock lock) {
        this.lockid = lock.id();
        return this;
    }

    public byte[] table() {
        return this.table;
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] family() {
        return this.family;
    }

    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    public String toString() {
        String klass = this.method() == GET ? "GetRequest" : "Exists";
        return super.toStringWithQualifiers(klass, this.family, this.qualifiers);
    }

    private int predictSerializedSize(byte server_version) {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 4;
        ++size;
        if (server_version >= 26) {
            ++size;
        }
        size += 8;
        size += 8;
        ++size;
        size += 4;
        if (this.family != null) {
            ++size;
            size += this.family.length;
            ++size;
            if (this.qualifiers != null) {
                size += 4;
                for (byte[] qualifier : this.qualifiers) {
                    size += 3;
                    size += qualifier.length;
                }
            }
        }
        if (server_version >= 29) {
            ++size;
        }
        return size;
    }

    ChannelBuffer serialize(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize(server_version));
        buf.writeInt(2);
        GetRequest.writeHBaseByteArray(buf, this.region.name());
        buf.writeByte(32);
        buf.writeByte(32);
        buf.writeByte(1);
        GetRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.lockid);
        buf.writeInt(1);
        buf.writeByte(0);
        if (server_version >= 26) {
            buf.writeByte(1);
        }
        buf.writeLong(0L);
        buf.writeLong(Long.MAX_VALUE);
        buf.writeByte(1);
        buf.writeInt(this.family != null ? 1 : 0);
        if (this.family != null) {
            GetRequest.writeByteArray(buf, this.family);
            if (this.qualifiers != null) {
                buf.writeByte(1);
                buf.writeInt(this.qualifiers.length);
                for (byte[] qualifier : this.qualifiers) {
                    GetRequest.writeByteArray(buf, qualifier);
                }
            } else {
                buf.writeByte(0);
            }
        }
        if (server_version >= 29) {
            buf.writeInt(0);
        }
        return buf;
    }
}

