/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public final class Bytes {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final Class<?> ReplayingDecoderBuffer;
    private static final Field RDB_buffer;
    public static final MemCmp MEMCMP;

    private Bytes() {
    }

    public static short getShort(byte[] b) {
        return Bytes.getShort(b, 0);
    }

    public static short getShort(byte[] b, int offset) {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    public static int getUnsignedShort(byte[] b) {
        return Bytes.getUnsignedShort(b, 0);
    }

    public static int getUnsignedShort(byte[] b, int offset) {
        return Bytes.getShort(b, offset) & 0xFFFF;
    }

    public static void setShort(byte[] b, short n) {
        Bytes.setShort(b, n, 0);
    }

    public static void setShort(byte[] b, short n, int offset) {
        b[offset + 0] = (byte)(n >>> 8);
        b[offset + 1] = (byte)(n >>> 0);
    }

    public static byte[] fromShort(short n) {
        byte[] b = new byte[2];
        Bytes.setShort(b, n);
        return b;
    }

    public static int getInt(byte[] b) {
        return Bytes.getInt(b, 0);
    }

    public static int getInt(byte[] b, int offset) {
        return (b[offset + 0] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | (b[offset + 3] & 0xFF) << 0;
    }

    public static long getUnsignedInt(byte[] b) {
        return Bytes.getUnsignedInt(b, 0);
    }

    public static long getUnsignedInt(byte[] b, int offset) {
        return (long)Bytes.getInt(b, offset) & 0xFFFFFFFFL;
    }

    public static void setInt(byte[] b, int n) {
        Bytes.setInt(b, n, 0);
    }

    public static void setInt(byte[] b, int n, int offset) {
        b[offset + 0] = (byte)(n >>> 24);
        b[offset + 1] = (byte)(n >>> 16);
        b[offset + 2] = (byte)(n >>> 8);
        b[offset + 3] = (byte)(n >>> 0);
    }

    public static byte[] fromInt(int n) {
        byte[] b = new byte[4];
        Bytes.setInt(b, n);
        return b;
    }

    public static long getLong(byte[] b) {
        return Bytes.getLong(b, 0);
    }

    public static long getLong(byte[] b, int offset) {
        return ((long)b[offset + 0] & 0xFFL) << 56 | ((long)b[offset + 1] & 0xFFL) << 48 | ((long)b[offset + 2] & 0xFFL) << 40 | ((long)b[offset + 3] & 0xFFL) << 32 | ((long)b[offset + 4] & 0xFFL) << 24 | ((long)b[offset + 5] & 0xFFL) << 16 | ((long)b[offset + 6] & 0xFFL) << 8 | ((long)b[offset + 7] & 0xFFL) << 0;
    }

    public static void setLong(byte[] b, long n) {
        Bytes.setLong(b, n, 0);
    }

    public static void setLong(byte[] b, long n, int offset) {
        b[offset + 0] = (byte)(n >>> 56);
        b[offset + 1] = (byte)(n >>> 48);
        b[offset + 2] = (byte)(n >>> 40);
        b[offset + 3] = (byte)(n >>> 32);
        b[offset + 4] = (byte)(n >>> 24);
        b[offset + 5] = (byte)(n >>> 16);
        b[offset + 6] = (byte)(n >>> 8);
        b[offset + 7] = (byte)(n >>> 0);
    }

    public static byte[] fromLong(long n) {
        byte[] b = new byte[8];
        Bytes.setLong(b, n);
        return b;
    }

    public static byte[] UTF8(String s) {
        return s.getBytes(CharsetUtil.UTF_8);
    }

    public static byte[] ISO88591(String s) {
        return s.getBytes(CharsetUtil.ISO_8859_1);
    }

    public static void pretty(StringBuilder outbuf, byte[] array) {
        if (array == null) {
            outbuf.append("null");
            return;
        }
        int ascii = 0;
        int start_length = outbuf.length();
        int n = array.length;
        outbuf.ensureCapacity(start_length + 1 + n + 1);
        outbuf.append('\"');
        for (int i = 0; i < n; ++i) {
            byte b = array[i];
            if (32 <= b && b <= 126) {
                ++ascii;
                outbuf.append((char)b);
                continue;
            }
            if (b == 10) {
                outbuf.append('\\').append('n');
                continue;
            }
            if (b == 9) {
                outbuf.append('\\').append('t');
                continue;
            }
            outbuf.append("\\x").append((char)HEX[b >>> 4 & 0xF]).append((char)HEX[b & 0xF]);
        }
        if (ascii < n / 2) {
            outbuf.setLength(start_length);
            outbuf.append(Arrays.toString(array));
        } else {
            outbuf.append('\"');
        }
    }

    public static String pretty(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(1 + array.length + 1);
        Bytes.pretty(buf, array);
        return buf.toString();
    }

    public static String hex(long v) {
        byte[] buf = new byte[18];
        buf[0] = 48;
        buf[1] = 120;
        int i = 18;
        do {
            buf[--i] = HEX[(int)v & 0xF];
        } while ((v >>>= 4) != 0L);
        while (i > 1) {
            buf[i] = 48;
            --i;
        }
        return new String(buf);
    }

    public static String pretty(ChannelBuffer buf) {
        byte[] array;
        if (buf == null) {
            return "null";
        }
        if (buf.getClass() != ReplayingDecoderBuffer) {
            array = buf.array();
        } else {
            try {
                ChannelBuffer wrapped_buf = (ChannelBuffer)RDB_buffer.get(buf);
                array = wrapped_buf.array();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)("Should not happen: " + e));
            }
        }
        return Bytes.pretty(array);
    }

    public static int memcmp(byte[] a, byte[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) - (b[i] & 0xFF);
        }
        return a.length - b.length;
    }

    public static int memcmp(byte[] a, byte[] b, int offset, int length) {
        if (a == b && a != null) {
            return 0;
        }
        length += offset;
        for (int i = offset; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) - (b[i] & 0xFF);
        }
        return 0;
    }

    public static byte[] deDup(byte[] old, byte[] neww) {
        return Bytes.memcmp(old, neww) == 0 ? old : neww;
    }

    public static boolean equals(byte[] a, byte[] b) {
        return Bytes.memcmp(a, b) == 0;
    }

    public static int memcmpMaybeNull(byte[] a, byte[] b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return Bytes.memcmp(a, b);
    }

    static {
        try {
            ReplayingDecoderBuffer = Class.forName("org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer");
            RDB_buffer = ReplayingDecoderBuffer.getDeclaredField("buffer");
            RDB_buffer.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("static initializer failed", e);
        }
        MEMCMP = new MemCmp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ByteMap<V>
    extends TreeMap<byte[], V>
    implements Iterable<Map.Entry<byte[], V>> {
        private static final long serialVersionUID = 1280744742L;

        public ByteMap() {
            super(MEMCMP);
        }

        @Override
        public Iterator<Map.Entry<byte[], V>> iterator() {
            return super.entrySet().iterator();
        }

        @Override
        public String toString() {
            int size = this.size();
            if (size == 0) {
                return "{}";
            }
            StringBuilder buf = new StringBuilder(size << 4);
            buf.append('{');
            for (Map.Entry<byte[], V> e : this) {
                Bytes.pretty(buf, e.getKey());
                buf.append('=');
                V value = e.getValue();
                if (value instanceof byte[]) {
                    Bytes.pretty(buf, (byte[])value);
                } else {
                    buf.append((Object)(value == this ? "(this map)" : value));
                }
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
            buf.append('}');
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MemCmp
    implements Comparator<byte[]> {
        private MemCmp() {
        }

        @Override
        public int compare(byte[] a, byte[] b) {
            return Bytes.memcmp(a, b);
        }
    }
}

