/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.stumbleupon.async.Callback;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.hbase.AsyncHbaseEventSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHBaseSink
extends AbstractSink
implements Configurable {
    private String tableName;
    private byte[] columnFamily;
    private long batchSize;
    private static final Logger logger = LoggerFactory.getLogger(AsyncHBaseSink.class);
    private AsyncHbaseEventSerializer serializer;
    private String eventSerializerType;
    private Context serializerContext;
    private HBaseClient client;
    private Configuration conf;
    private Transaction txn;
    private volatile boolean open = false;
    private SinkCounter sinkCounter;
    private long timeout;

    public AsyncHBaseSink() {
        this.conf = HBaseConfiguration.create();
    }

    public AsyncHBaseSink(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sink.Status process() throws EventDeliveryException {
        if (!this.open) {
            throw new EventDeliveryException("Sink was never opened. Please fix the configuration.");
        }
        AtomicBoolean txnFail = new AtomicBoolean(false);
        AtomicInteger callbacksReceived = new AtomicInteger(0);
        AtomicInteger callbacksExpected = new AtomicInteger(0);
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        SuccessCallback putSuccessCallback = new SuccessCallback(lock, callbacksReceived, condition);
        FailureCallback putFailureCallback = new FailureCallback(lock, callbacksReceived, txnFail, condition);
        SuccessCallback incrementSuccessCallback = new SuccessCallback(lock, callbacksReceived, condition);
        FailureCallback incrementFailureCallback = new FailureCallback(lock, callbacksReceived, txnFail, condition);
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        int i = 0;
        try {
            this.txn = channel.getTransaction();
            this.txn.begin();
            while ((long)i < this.batchSize) {
                Event event = channel.take();
                if (event == null) {
                    status = Sink.Status.BACKOFF;
                    if (i == 0) {
                        this.sinkCounter.incrementBatchEmptyCount();
                    } else {
                        this.sinkCounter.incrementBatchUnderflowCount();
                    }
                    break;
                }
                this.serializer.setEvent(event);
                List<PutRequest> actions = this.serializer.getActions();
                List<AtomicIncrementRequest> increments = this.serializer.getIncrements();
                callbacksExpected.addAndGet(actions.size() + increments.size());
                for (PutRequest action : actions) {
                    this.client.put(action).addCallbacks(putSuccessCallback, putFailureCallback);
                }
                for (AtomicIncrementRequest increment : increments) {
                    this.client.atomicIncrement(increment).addCallbacks(incrementSuccessCallback, incrementFailureCallback);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            this.handleTransactionFailure(this.txn);
            this.checkIfChannelExceptionAndThrow(e);
        }
        if ((long)i == this.batchSize) {
            this.sinkCounter.incrementBatchCompleteCount();
        }
        this.sinkCounter.addToEventDrainAttemptCount((long)i);
        lock.lock();
        try {
            while (callbacksReceived.get() < callbacksExpected.get() && !txnFail.get()) {
                try {
                    if (condition.await(this.timeout, TimeUnit.MILLISECONDS)) continue;
                    txnFail.set(true);
                    logger.warn("HBase callbacks timed out. Transaction will be rolled back.");
                }
                catch (Exception ex) {
                    logger.error("Exception while waiting for callbacks from HBase.");
                    this.handleTransactionFailure(this.txn);
                    Throwables.propagate((Throwable)ex);
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (txnFail.get()) {
            this.handleTransactionFailure(this.txn);
            throw new EventDeliveryException("Could not write events to Hbase. Transaction failed, and rolled back.");
        }
        try {
            this.txn.commit();
            this.txn.close();
            this.sinkCounter.addToEventDrainSuccessCount((long)i);
            return status;
        }
        catch (Throwable e) {
            this.handleTransactionFailure(this.txn);
            this.checkIfChannelExceptionAndThrow(e);
        }
        return status;
    }

    public void configure(Context context) {
        this.tableName = context.getString("table");
        String cf = context.getString("columnFamily");
        this.batchSize = context.getLong("batchSize", new Long(100L));
        this.serializerContext = new Context();
        this.eventSerializerType = context.getString("serializer");
        Preconditions.checkNotNull((Object)this.tableName, (Object)"Table name cannot be empty, please specify in configuration file");
        Preconditions.checkNotNull((Object)cf, (Object)"Column family cannot be empty, please specify in configuration file");
        if (this.eventSerializerType == null || this.eventSerializerType.isEmpty()) {
            this.eventSerializerType = "org.apache.flume.sink.hbase.SimpleAsyncHbaseEventSerializer";
            logger.info("No serializer defined, Will use default");
        }
        this.serializerContext.putAll((Map)context.getSubProperties("serializer."));
        this.columnFamily = cf.getBytes(Charsets.UTF_8);
        try {
            Class<?> clazz = Class.forName(this.eventSerializerType);
            this.serializer = (AsyncHbaseEventSerializer)clazz.newInstance();
            this.serializer.configure(this.serializerContext);
            this.serializer.initialize(this.tableName.getBytes(Charsets.UTF_8), this.columnFamily);
        }
        catch (Exception e) {
            logger.error("Could not instantiate event serializer.", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.timeout = context.getLong("timeout", Long.valueOf(Long.MAX_VALUE));
        if (this.timeout <= 0L) {
            logger.warn("Timeout should be positive for Hbase sink. Sink will not timeout.");
            this.timeout = Long.MAX_VALUE;
        }
    }

    public void start() {
        Preconditions.checkArgument((this.client == null ? 1 : 0) != 0, (Object)"Please call stop before calling start on an old instance.");
        this.sinkCounter.start();
        this.sinkCounter.incrementConnectionCreatedCount();
        String zkQuorum = this.conf.get("hbase.zookeeper.quorum");
        String zkBaseDir = this.conf.get("zookeeper.znode.parent");
        this.client = zkBaseDir != null ? new HBaseClient(zkQuorum, zkBaseDir) : new HBaseClient(zkQuorum);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean fail = new AtomicBoolean(false);
        this.client.ensureTableFamilyExists(this.tableName.getBytes(Charsets.UTF_8), this.columnFamily).addCallbacks((Callback)new Callback<Object, Object>(){

            public Object call(Object arg) throws Exception {
                latch.countDown();
                return null;
            }
        }, (Callback)new Callback<Object, Object>(){

            public Object call(Object arg) throws Exception {
                fail.set(true);
                latch.countDown();
                return null;
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.sinkCounter.incrementConnectionFailedCount();
            throw new FlumeException("Interrupted while waiting for Hbase Callbacks", (Throwable)e);
        }
        if (fail.get()) {
            this.sinkCounter.incrementConnectionFailedCount();
            throw new FlumeException("Could not start sink. Table or column family does not exist in Hbase.");
        }
        this.open = true;
        this.client.setFlushInterval((short)0);
        super.start();
    }

    public void stop() {
        this.serializer.cleanUp();
        this.client.shutdown();
        this.sinkCounter.incrementConnectionClosedCount();
        this.sinkCounter.stop();
        this.client = null;
        this.open = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionFailure(Transaction txn) throws EventDeliveryException {
        block6: {
            try {
                txn.rollback();
            }
            catch (Throwable e) {
                logger.error("Failed to commit transaction.Transaction rolled back.", e);
                if (e instanceof Error || e instanceof RuntimeException) {
                    logger.error("Failed to commit transaction.Transaction rolled back.", e);
                    Throwables.propagate((Throwable)e);
                    break block6;
                }
                logger.error("Failed to commit transaction.Transaction rolled back.", e);
                throw new EventDeliveryException("Failed to commit transaction.Transaction rolled back.", e);
            }
            finally {
                txn.close();
            }
        }
    }

    private void checkIfChannelExceptionAndThrow(Throwable e) throws EventDeliveryException {
        if (e instanceof ChannelException) {
            throw new EventDeliveryException("Error in processing transaction.", e);
        }
        if (e instanceof Error || e instanceof RuntimeException) {
            Throwables.propagate((Throwable)e);
        }
        throw new EventDeliveryException("Error in processing transaction.", e);
    }

    private class FailureCallback<R, T>
    implements Callback<R, T> {
        private Lock lock;
        private AtomicInteger callbacksReceived;
        private AtomicBoolean txnFail;
        private Condition condition;

        public FailureCallback(Lock lck, AtomicInteger callbacksReceived, AtomicBoolean txnFail, Condition condition) {
            this.lock = lck;
            this.callbacksReceived = callbacksReceived;
            this.txnFail = txnFail;
            this.condition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R call(T arg) throws Exception {
            this.callbacksReceived.incrementAndGet();
            this.txnFail.set(true);
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }

    private class SuccessCallback<R, T>
    implements Callback<R, T> {
        private Lock lock;
        private AtomicInteger callbacksReceived;
        private Condition condition;

        public SuccessCallback(Lock lck, AtomicInteger callbacksReceived, Condition condition) {
            this.lock = lck;
            this.callbacksReceived = callbacksReceived;
            this.condition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R call(T arg) throws Exception {
            this.callbacksReceived.incrementAndGet();
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }
}

