/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;

public class HDFSSequenceFile
implements HDFSWriter {
    private SequenceFile.Writer writer = null;

    public void configure(Context context) {
    }

    @Override
    public void open(String filePath, FlumeFormatter fmt) throws IOException {
        this.open(filePath, null, SequenceFile.CompressionType.NONE, fmt);
    }

    @Override
    public void open(String filePath, CompressionCodec codeC, SequenceFile.CompressionType compType, FlumeFormatter fmt) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = dstPath.getFileSystem(conf);
        if (conf.getBoolean("hdfs.append.support", false) && hdfs.isFile(dstPath)) {
            FSDataOutputStream outStream = hdfs.append(dstPath);
            this.writer = SequenceFile.createWriter((Configuration)conf, (FSDataOutputStream)outStream, (Class)fmt.getKeyClass(), (Class)fmt.getValueClass(), (SequenceFile.CompressionType)compType, (CompressionCodec)codeC);
        } else {
            this.writer = SequenceFile.createWriter((FileSystem)hdfs, (Configuration)conf, (Path)dstPath, (Class)fmt.getKeyClass(), (Class)fmt.getValueClass(), (SequenceFile.CompressionType)compType, (CompressionCodec)codeC);
        }
    }

    @Override
    public void append(Event e, FlumeFormatter formatter) throws IOException {
        this.writer.append(formatter.getKey(e), formatter.getValue(e));
    }

    @Override
    public void sync() throws IOException {
        this.writer.syncFs();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

