/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.formatter.output.BucketPath;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.flume.sink.hdfs.BucketWriter;
import org.apache.flume.sink.hdfs.HDFSFormatterFactory;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.flume.sink.hdfs.HDFSWriterFactory;
import org.apache.flume.sink.hdfs.KerberosUser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSEventSink
extends AbstractSink
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSEventSink.class);
    private static final long defaultRollInterval = 30L;
    private static final long defaultRollSize = 1024L;
    private static final long defaultRollCount = 10L;
    private static final String defaultFileName = "FlumeData";
    private static final String defaultSuffix = "";
    private static final long defaultBatchSize = 100L;
    private static final long defaultTxnEventMax = 100L;
    private static final String defaultFileType = "SequenceFile";
    private static final int defaultMaxOpenFiles = 5000;
    private static final long defaultCallTimeout = 10000L;
    private static final int defaultThreadPoolSize = 10;
    private static final int defaultRollTimerPoolSize = 1;
    private static final AtomicReference<KerberosUser> staticLogin = new AtomicReference();
    private final HDFSWriterFactory writerFactory;
    private WriterLinkedHashMap sfWriters;
    private long rollInterval;
    private long rollSize;
    private long rollCount;
    private long batchSize;
    private int threadsPoolSize;
    private int rollTimerPoolSize;
    private CompressionCodec codeC;
    private SequenceFile.CompressionType compType;
    private String fileType;
    private String path;
    private String suffix;
    private TimeZone timeZone;
    private int maxOpenFiles;
    private String writeFormat;
    private ExecutorService callTimeoutPool;
    private ScheduledExecutorService timedRollerPool;
    private String kerbConfPrincipal;
    private String kerbKeytab;
    private String proxyUserName;
    private UserGroupInformation proxyTicket;
    private boolean needRounding = false;
    private int roundUnit = 13;
    private int roundValue = 1;
    private long callTimeout;
    private Context context;
    private SinkCounter sinkCounter;
    private volatile int idleTimeout;

    public HDFSEventSink() {
        this(new HDFSWriterFactory());
    }

    public HDFSEventSink(HDFSWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void configure(Context context) {
        this.context = context;
        String dirpath = (String)Preconditions.checkNotNull((Object)context.getString("hdfs.path"), (Object)"hdfs.path is required");
        String fileName = context.getString("hdfs.filePrefix", defaultFileName);
        this.suffix = context.getString("hdfs.fileSuffix", defaultSuffix);
        this.path = dirpath + System.getProperty("file.separator") + fileName;
        String tzName = context.getString("hdfs.timeZone");
        this.timeZone = tzName == null ? null : TimeZone.getTimeZone(tzName);
        this.rollInterval = context.getLong("hdfs.rollInterval", Long.valueOf(30L));
        this.rollSize = context.getLong("hdfs.rollSize", Long.valueOf(1024L));
        this.rollCount = context.getLong("hdfs.rollCount", Long.valueOf(10L));
        this.batchSize = context.getLong("hdfs.batchSize", Long.valueOf(100L));
        this.idleTimeout = context.getInteger("hdfs.idleTimeout", Integer.valueOf(0));
        String codecName = context.getString("hdfs.codeC");
        this.fileType = context.getString("hdfs.fileType", defaultFileType);
        this.maxOpenFiles = context.getInteger("hdfs.maxOpenFiles", Integer.valueOf(5000));
        this.writeFormat = context.getString("hdfs.writeFormat");
        this.callTimeout = context.getLong("hdfs.callTimeout", Long.valueOf(10000L));
        this.threadsPoolSize = context.getInteger("hdfs.threadsPoolSize", Integer.valueOf(10));
        this.rollTimerPoolSize = context.getInteger("hdfs.rollTimerPoolSize", Integer.valueOf(1));
        this.kerbConfPrincipal = context.getString("hdfs.kerberosPrincipal", defaultSuffix);
        this.kerbKeytab = context.getString("hdfs.kerberosKeytab", defaultSuffix);
        this.proxyUserName = context.getString("hdfs.proxyUser", defaultSuffix);
        Preconditions.checkArgument((this.batchSize > 0L ? 1 : 0) != 0, (Object)"batchSize must be greater than 0");
        if (codecName == null) {
            this.codeC = null;
            this.compType = SequenceFile.CompressionType.NONE;
        } else {
            this.codeC = HDFSEventSink.getCodec(codecName);
            this.compType = SequenceFile.CompressionType.BLOCK;
        }
        if (this.fileType.equalsIgnoreCase("DataStream") && codecName != null) {
            throw new IllegalArgumentException("fileType: " + this.fileType + " which does NOT support compressed output. Please don't set codeC" + " or change the fileType if compressed output is desired.");
        }
        if (this.fileType.equalsIgnoreCase("CompressedStream")) {
            Preconditions.checkNotNull((Object)this.codeC, (Object)("It's essential to set compress codec when fileType is: " + this.fileType));
        }
        if (this.writeFormat == null) {
            this.writeFormat = this.fileType.equalsIgnoreCase("DataStream") || this.fileType.equalsIgnoreCase("CompressedStream") ? "Text" : "Writable";
        }
        if (!this.authenticate(this.path)) {
            LOG.error("Failed to authenticate!");
        }
        this.needRounding = context.getBoolean("hdfs.round", Boolean.valueOf(false));
        if (this.needRounding) {
            String unit = context.getString("hdfs.roundUnit", "second");
            if (unit.equalsIgnoreCase("hour")) {
                this.roundUnit = 11;
            } else if (unit.equalsIgnoreCase("minute")) {
                this.roundUnit = 12;
            } else if (unit.equalsIgnoreCase("second")) {
                this.roundUnit = 13;
            } else {
                LOG.warn("Rounding unit is not valid, please set one ofminute, hour, or second. Rounding will be disabled");
                this.needRounding = false;
            }
            this.roundValue = context.getInteger("hdfs.roundValue", Integer.valueOf(1));
            if (this.roundUnit == 13 || this.roundUnit == 12) {
                Preconditions.checkArgument((this.roundValue > 0 && this.roundValue <= 60 ? 1 : 0) != 0, (Object)"Round valuemust be > 0 and <= 60");
            } else if (this.roundUnit == 11) {
                Preconditions.checkArgument((this.roundValue > 0 && this.roundValue <= 24 ? 1 : 0) != 0, (Object)"Round valuemust be > 0 and <= 24");
            }
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
    }

    private static boolean codecMatches(Class<? extends CompressionCodec> cls, String codecName) {
        String prefix;
        String simpleName = cls.getSimpleName();
        if (cls.getName().equals(codecName) || simpleName.equalsIgnoreCase(codecName)) {
            return true;
        }
        return simpleName.endsWith("Codec") && (prefix = simpleName.substring(0, simpleName.length() - "Codec".length())).equalsIgnoreCase(codecName);
    }

    private static CompressionCodec getCodec(String codecName) {
        Configuration conf = new Configuration();
        List codecs = CompressionCodecFactory.getCodecClasses((Configuration)conf);
        CompressionCodec codec = null;
        ArrayList<String> codecStrs = new ArrayList<String>();
        codecStrs.add("None");
        for (Class cls : codecs) {
            codecStrs.add(cls.getSimpleName());
            if (!HDFSEventSink.codecMatches(cls, codecName)) continue;
            try {
                codec = (CompressionCodec)cls.newInstance();
            }
            catch (InstantiationException e) {
                LOG.error("Unable to instantiate " + cls + " class");
            }
            catch (IllegalAccessException e) {
                LOG.error("Unable to access " + cls + " class");
            }
        }
        if (codec == null) {
            if (!codecName.equalsIgnoreCase("None")) {
                throw new IllegalArgumentException("Unsupported compression codec " + codecName + ".  Please choose from: " + codecStrs);
            }
        } else if (codec instanceof org.apache.hadoop.conf.Configurable) {
            ((org.apache.hadoop.conf.Configurable)codec).setConf(conf);
        }
        return codec;
    }

    private <T> T callWithTimeout(Callable<T> callable) throws IOException, InterruptedException {
        Future<T> future = this.callTimeoutPool.submit(callable);
        try {
            if (this.callTimeout > 0L) {
                return future.get(this.callTimeout, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (TimeoutException eT) {
            future.cancel(true);
            this.sinkCounter.incrementConnectionFailedCount();
            throw new IOException("Callable timed out after " + this.callTimeout + " ms", eT);
        }
        catch (ExecutionException e1) {
            this.sinkCounter.incrementConnectionFailedCount();
            Throwable cause = e1.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e1);
        }
        catch (CancellationException ce) {
            throw new InterruptedException("Blocked callable interrupted by rotation event");
        }
        catch (InterruptedException ex) {
            LOG.warn("Unexpected Exception " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status;
        Channel channel = this.getChannel();
        Transaction transaction = channel.getTransaction();
        ArrayList writers = Lists.newArrayList();
        transaction.begin();
        try {
            Event event;
            int txnEventCount = 0;
            txnEventCount = 0;
            while ((long)txnEventCount < this.batchSize && (event = channel.take()) != null) {
                String realPath = BucketPath.escapeString((String)this.path, (Map)event.getHeaders(), (TimeZone)this.timeZone, (boolean)this.needRounding, (int)this.roundUnit, (int)this.roundValue);
                BucketWriter bucketWriter = (BucketWriter)this.sfWriters.get(realPath);
                if (bucketWriter == null) {
                    HDFSWriter hdfsWriter = this.writerFactory.getWriter(this.fileType);
                    FlumeFormatter formatter = HDFSFormatterFactory.getFormatter(this.writeFormat);
                    WriterCallback idleCallback = null;
                    if (this.idleTimeout != 0) {
                        idleCallback = new WriterCallback(){

                            @Override
                            public void run(String bucketPath) {
                                HDFSEventSink.this.sfWriters.remove(bucketPath);
                            }
                        };
                    }
                    bucketWriter = new BucketWriter(this.rollInterval, this.rollSize, this.rollCount, this.batchSize, this.context, realPath, this.suffix, this.codeC, this.compType, hdfsWriter, formatter, this.timedRollerPool, this.proxyTicket, this.sinkCounter, this.idleTimeout, idleCallback);
                    this.sfWriters.put(realPath, bucketWriter);
                }
                if (!writers.contains(bucketWriter)) {
                    writers.add(bucketWriter);
                }
                this.append(bucketWriter, event);
                ++txnEventCount;
            }
            if (txnEventCount == 0) {
                this.sinkCounter.incrementBatchEmptyCount();
            } else if ((long)txnEventCount == this.batchSize) {
                this.sinkCounter.incrementBatchCompleteCount();
            } else {
                this.sinkCounter.incrementBatchUnderflowCount();
            }
            for (BucketWriter bucketWriter : writers) {
                this.flush(bucketWriter);
            }
            transaction.commit();
            if (txnEventCount < 1) {
                status = Sink.Status.BACKOFF;
                return status;
            }
            this.sinkCounter.addToEventDrainSuccessCount((long)txnEventCount);
            status = Sink.Status.READY;
            return status;
        }
        catch (IOException eIO) {
            transaction.rollback();
            LOG.warn("HDFS IO error", (Throwable)eIO);
            status = Sink.Status.BACKOFF;
            return status;
        }
        catch (Throwable th) {
            transaction.rollback();
            LOG.error("process failed", th);
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new EventDeliveryException(th);
        }
        finally {
            transaction.close();
        }
    }

    public void stop() {
        ExecutorService[] toShutdown;
        for (Map.Entry entry : this.sfWriters.entrySet()) {
            LOG.info("Closing {}", entry.getKey());
            try {
                this.close((BucketWriter)entry.getValue());
            }
            catch (Exception ex) {
                LOG.warn("Exception while closing " + (String)entry.getKey() + ". " + "Exception follows.", (Throwable)ex);
                if (!(ex instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
        }
        for (ExecutorService execService : toShutdown = new ExecutorService[]{this.callTimeoutPool, this.timedRollerPool}) {
            execService.shutdown();
            try {
                while (!execService.isTerminated()) {
                    execService.awaitTermination(Math.max(10000L, this.callTimeout), TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("shutdown interrupted on " + execService, (Throwable)ex);
            }
        }
        this.callTimeoutPool = null;
        this.timedRollerPool = null;
        this.sfWriters.clear();
        this.sfWriters = null;
        this.sinkCounter.stop();
        super.stop();
    }

    public void start() {
        String timeoutName = "hdfs-" + this.getName() + "-call-runner-%d";
        this.callTimeoutPool = Executors.newFixedThreadPool(this.threadsPoolSize, new ThreadFactoryBuilder().setNameFormat(timeoutName).build());
        String rollerName = "hdfs-" + this.getName() + "-roll-timer-%d";
        this.timedRollerPool = Executors.newScheduledThreadPool(this.rollTimerPoolSize, new ThreadFactoryBuilder().setNameFormat(rollerName).build());
        this.sfWriters = new WriterLinkedHashMap(this.maxOpenFiles);
        this.sinkCounter.start();
        super.start();
    }

    private boolean authenticate(String hdfsPath) {
        boolean useSecurity = UserGroupInformation.isSecurityEnabled();
        LOG.info("Hadoop Security enabled: " + useSecurity);
        if (useSecurity) {
            String principal;
            if (this.kerbConfPrincipal.isEmpty()) {
                LOG.error("Hadoop running in secure mode, but Flume config doesn't specify a principal to use for Kerberos auth.");
                return false;
            }
            if (this.kerbKeytab.isEmpty()) {
                LOG.error("Hadoop running in secure mode, but Flume config doesn't specify a keytab to use for Kerberos auth.");
                return false;
            }
            File kfile = new File(this.kerbKeytab);
            if (!kfile.isFile() || !kfile.canRead()) {
                throw new IllegalArgumentException("The keyTab file: " + this.kerbKeytab + " is nonexistent or can't read. " + "Please specify a readable keytab file for Kerberos auth.");
            }
            try {
                principal = SecurityUtil.getServerPrincipal((String)this.kerbConfPrincipal, (String)defaultSuffix);
            }
            catch (IOException e) {
                LOG.error("Host lookup error resolving kerberos principal (" + this.kerbConfPrincipal + "). Exception follows.", (Throwable)e);
                return false;
            }
            Preconditions.checkNotNull((Object)principal, (Object)"Principal must not be null");
            KerberosUser prevUser = staticLogin.get();
            KerberosUser newUser = new KerberosUser(principal, this.kerbKeytab);
            Preconditions.checkState((prevUser == null || prevUser.equals(newUser) ? 1 : 0) != 0, (String)"Cannot use multiple kerberos principals in the same agent.  Must restart agent to use new principal or keytab. Previous = %s, New = %s", (Object[])new Object[]{prevUser, newUser});
            UserGroupInformation curUser = null;
            if (prevUser != null && prevUser.equals(newUser)) {
                try {
                    curUser = UserGroupInformation.getLoginUser();
                }
                catch (IOException e) {
                    LOG.warn("User unexpectedly had no active login. Continuing with authentication", (Throwable)e);
                }
            }
            if (curUser == null || !curUser.getUserName().equals(principal)) {
                try {
                    HDFSEventSink.kerberosLogin(this, principal, this.kerbKeytab);
                }
                catch (IOException e) {
                    LOG.error("Authentication or file read error while attempting to login as kerberos principal (" + principal + ") using " + "keytab (" + this.kerbKeytab + "). Exception follows.", (Throwable)e);
                    return false;
                }
            } else {
                LOG.debug("{}: Using existing principal login: {}", (Object)this, (Object)curUser);
            }
            staticLogin.set(newUser);
        }
        this.proxyTicket = null;
        if (!this.proxyUserName.isEmpty()) {
            try {
                this.proxyTicket = UserGroupInformation.createProxyUser((String)this.proxyUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
            catch (IOException e) {
                LOG.error("Unable to login as proxy user. Exception follows.", (Throwable)e);
                return false;
            }
        }
        UserGroupInformation ugi = null;
        if (this.proxyTicket != null) {
            ugi = this.proxyTicket;
        } else if (useSecurity) {
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error("Unexpected error: Unable to get authenticated user after apparent successful login! Exception follows.", (Throwable)e);
                return false;
            }
        }
        if (ugi != null) {
            UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
            LOG.info("Auth method: {}", (Object)authMethod);
            LOG.info(" User name: {}", (Object)ugi.getUserName());
            LOG.info(" Using keytab: {}", (Object)ugi.isFromKeytab());
            if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
                try {
                    UserGroupInformation superUser = UserGroupInformation.getLoginUser();
                    LOG.info(" Superuser auth: {}", (Object)superUser.getAuthenticationMethod());
                    LOG.info(" Superuser name: {}", (Object)superUser.getUserName());
                    LOG.info(" Superuser using keytab: {}", (Object)superUser.isFromKeytab());
                }
                catch (IOException e) {
                    LOG.error("Unexpected error: unknown superuser impersonating proxy.", (Throwable)e);
                    return false;
                }
            }
            LOG.info("Logged in as user {}", (Object)ugi.getUserName());
            return true;
        }
        return true;
    }

    private static synchronized UserGroupInformation kerberosLogin(HDFSEventSink sink, String principal, String keytab) throws IOException {
        UserGroupInformation curUser = null;
        try {
            curUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.debug("Unable to get login user before Kerberos auth attempt.", (Throwable)e);
        }
        if (curUser != null && curUser.getUserName().equals(principal)) {
            LOG.debug("{}: Using existing principal ({}): {}", new Object[]{sink, principal, curUser});
        } else {
            LOG.info("{}: Attempting kerberos login as principal ({}) from keytab file ({})", new Object[]{sink, principal, keytab});
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            curUser = UserGroupInformation.getLoginUser();
        }
        return curUser;
    }

    public String toString() {
        return "{ Sink type:" + ((Object)((Object)this)).getClass().getSimpleName() + ", name:" + this.getName() + " }";
    }

    private void append(final BucketWriter bucketWriter, final Event event) throws IOException, InterruptedException {
        this.callWithTimeout(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                bucketWriter.append(event);
                return null;
            }
        });
    }

    private void flush(final BucketWriter bucketWriter) throws IOException, InterruptedException {
        this.callWithTimeout(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                bucketWriter.flush();
                return null;
            }
        });
    }

    private void close(final BucketWriter bucketWriter) throws IOException, InterruptedException {
        this.callWithTimeout(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                bucketWriter.close();
                return null;
            }
        });
    }

    private static class WriterLinkedHashMap
    extends LinkedHashMap<String, BucketWriter> {
        private final int maxOpenFiles;

        public WriterLinkedHashMap(int maxOpenFiles) {
            super(16, 0.75f, true);
            this.maxOpenFiles = maxOpenFiles;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BucketWriter> eldest) {
            if (this.size() > this.maxOpenFiles) {
                try {
                    eldest.getValue().close();
                }
                catch (IOException e) {
                    LOG.warn(eldest.getKey().toString(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.warn(eldest.getKey().toString(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            return false;
        }
    }

    public static interface WriterCallback {
        public void run(String var1);
    }
}

