/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Clock;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.SystemClock;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.flume.sink.hdfs.HDFSEventSink;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BucketWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BucketWriter.class);
    static final String IN_USE_EXT = ".tmp";
    private static final Integer staticLock = new Integer(1);
    private final HDFSWriter writer;
    private final FlumeFormatter formatter;
    private final long rollInterval;
    private final long rollSize;
    private final long rollCount;
    private final long batchSize;
    private final CompressionCodec codeC;
    private final SequenceFile.CompressionType compType;
    private final Context context;
    private final ScheduledExecutorService timedRollerPool;
    private final UserGroupInformation user;
    private final AtomicLong fileExtensionCounter;
    private long eventCounter;
    private long processSize;
    private FileSystem fileSystem;
    private volatile String filePath;
    private volatile String fileSuffix;
    private volatile String bucketPath;
    private volatile long batchCounter;
    private volatile boolean isOpen;
    private volatile ScheduledFuture<Void> timedRollFuture;
    private SinkCounter sinkCounter;
    private final HDFSEventSink.WriterCallback onIdleCallback;
    private final int idleTimeout;
    private volatile ScheduledFuture<Void> idleFuture;
    private Clock clock = new SystemClock();
    protected boolean idleClosed = false;

    BucketWriter(long rollInterval, long rollSize, long rollCount, long batchSize, Context context, String filePath, String fileSuffix, CompressionCodec codeC, SequenceFile.CompressionType compType, HDFSWriter writer, FlumeFormatter formatter, ScheduledExecutorService timedRollerPool, UserGroupInformation user, SinkCounter sinkCounter, int idleTimeout, HDFSEventSink.WriterCallback onIdleCallback) {
        this.rollInterval = rollInterval;
        this.rollSize = rollSize;
        this.rollCount = rollCount;
        this.batchSize = batchSize;
        this.context = context;
        this.filePath = filePath;
        this.fileSuffix = fileSuffix;
        this.codeC = codeC;
        this.compType = compType;
        this.writer = writer;
        this.formatter = formatter;
        this.timedRollerPool = timedRollerPool;
        this.user = user;
        this.sinkCounter = sinkCounter;
        this.onIdleCallback = onIdleCallback;
        this.idleTimeout = idleTimeout;
        this.fileExtensionCounter = new AtomicLong(this.clock.currentTimeMillis());
        this.isOpen = false;
        writer.configure(context);
    }

    private <T> T runPrivileged(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        if (this.user != null) {
            return (T)this.user.doAs(action);
        }
        try {
            return action.run();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception.", ex);
        }
    }

    private void resetCounters() {
        this.eventCounter = 0L;
        this.processSize = 0L;
        this.batchCounter = 0L;
    }

    private void open() throws IOException, InterruptedException {
        this.runPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                BucketWriter.this.doOpen();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen() throws IOException {
        if (this.filePath == null || this.writer == null || this.formatter == null) {
            throw new IOException("Invalid file settings");
        }
        Configuration config = new Configuration();
        config.setBoolean("fs.automatic.close", false);
        Integer n = staticLock;
        synchronized (n) {
            try {
                long counter = this.fileExtensionCounter.incrementAndGet();
                if (this.codeC == null) {
                    this.bucketPath = this.filePath + "." + counter;
                    if (this.fileSuffix != null && this.fileSuffix.length() > 0) {
                        this.bucketPath = this.bucketPath + this.fileSuffix;
                    }
                    this.fileSystem = new Path(this.bucketPath).getFileSystem(config);
                    LOG.info("Creating " + this.bucketPath + IN_USE_EXT);
                    this.writer.open(this.bucketPath + IN_USE_EXT, this.formatter);
                } else {
                    this.bucketPath = this.filePath + "." + counter + this.codeC.getDefaultExtension();
                    this.fileSystem = new Path(this.bucketPath).getFileSystem(config);
                    LOG.info("Creating " + this.bucketPath + IN_USE_EXT);
                    this.writer.open(this.bucketPath + IN_USE_EXT, this.codeC, this.compType, this.formatter);
                }
            }
            catch (Exception ex) {
                this.sinkCounter.incrementConnectionFailedCount();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw Throwables.propagate((Throwable)ex);
            }
        }
        this.sinkCounter.incrementConnectionCreatedCount();
        this.resetCounters();
        if (this.rollInterval > 0L) {
            Callable<Void> action = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LOG.debug("Rolling file ({}): Roll scheduled after {} sec elapsed.", (Object)(BucketWriter.this.bucketPath + BucketWriter.IN_USE_EXT), (Object)BucketWriter.this.rollInterval);
                    try {
                        BucketWriter.this.close();
                    }
                    catch (Throwable t) {
                        LOG.error("Unexpected error", t);
                    }
                    return null;
                }
            };
            this.timedRollFuture = this.timedRollerPool.schedule(action, this.rollInterval, TimeUnit.SECONDS);
        }
        this.isOpen = true;
    }

    public synchronized void close() throws IOException, InterruptedException {
        this.flush();
        this.runPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                BucketWriter.this.doClose();
                return null;
            }
        });
    }

    private void doClose() throws IOException {
        LOG.debug("Closing {}", (Object)(this.bucketPath + IN_USE_EXT));
        if (this.isOpen) {
            try {
                this.writer.close();
                this.sinkCounter.incrementConnectionClosedCount();
            }
            catch (IOException e) {
                LOG.warn("failed to close() HDFSWriter for file (" + this.bucketPath + IN_USE_EXT + "). Exception follows.", (Throwable)e);
                this.sinkCounter.incrementConnectionFailedCount();
            }
            this.isOpen = false;
        } else {
            LOG.info("HDFSWriter is already closed: {}", (Object)(this.bucketPath + IN_USE_EXT));
        }
        if (this.timedRollFuture != null && !this.timedRollFuture.isDone()) {
            this.timedRollFuture.cancel(false);
            this.timedRollFuture = null;
        }
        if (this.idleFuture != null && !this.idleFuture.isDone()) {
            this.idleFuture.cancel(false);
            this.idleFuture = null;
        }
        if (this.bucketPath != null && this.fileSystem != null) {
            this.renameBucket();
            this.fileSystem = null;
        }
    }

    public synchronized void flush() throws IOException, InterruptedException {
        if (!this.isBatchComplete()) {
            this.runPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    BucketWriter.this.doFlush();
                    return null;
                }
            });
            if (this.idleTimeout > 0 && (this.idleFuture == null || this.idleFuture.cancel(false))) {
                Callable<Void> idleAction = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            LOG.info("Closing idle bucketWriter {}", (Object)BucketWriter.this.filePath);
                            BucketWriter.this.idleClosed = true;
                            BucketWriter.this.close();
                            if (BucketWriter.this.onIdleCallback != null) {
                                BucketWriter.this.onIdleCallback.run(BucketWriter.this.filePath);
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("Unexpected error", t);
                        }
                        return null;
                    }
                };
                this.idleFuture = this.timedRollerPool.schedule(idleAction, (long)this.idleTimeout, TimeUnit.SECONDS);
            }
        }
    }

    private void doFlush() throws IOException {
        this.writer.sync();
        this.batchCounter = 0L;
    }

    public synchronized void append(Event event) throws IOException, InterruptedException {
        if (!this.isOpen) {
            if (this.idleClosed) {
                throw new IOException("This bucket writer was closed due to idling and this handle is thus no longer valid");
            }
            this.open();
        }
        if (this.shouldRotate()) {
            this.close();
            this.open();
        }
        try {
            this.sinkCounter.incrementEventDrainAttemptCount();
            this.writer.append(event, this.formatter);
        }
        catch (IOException e) {
            LOG.warn("Caught IOException writing to HDFSWriter ({}). Closing file (" + this.bucketPath + IN_USE_EXT + ") and rethrowing exception.", (Object)e.getMessage());
            try {
                this.close();
            }
            catch (IOException e2) {
                LOG.warn("Caught IOException while closing file (" + this.bucketPath + IN_USE_EXT + "). Exception follows.", (Throwable)e2);
            }
            throw e;
        }
        this.processSize += (long)event.getBody().length;
        ++this.eventCounter;
        ++this.batchCounter;
        if (this.batchCounter == this.batchSize) {
            this.flush();
        }
    }

    private boolean shouldRotate() {
        boolean doRotate = false;
        if (this.rollCount > 0L && this.rollCount <= this.eventCounter) {
            LOG.debug("rolling: rollCount: {}, events: {}", (Object)this.rollCount, (Object)this.eventCounter);
            doRotate = true;
        }
        if (this.rollSize > 0L && this.rollSize <= this.processSize) {
            LOG.debug("rolling: rollSize: {}, bytes: {}", (Object)this.rollSize, (Object)this.processSize);
            doRotate = true;
        }
        return doRotate;
    }

    private void renameBucket() throws IOException {
        Path srcPath = new Path(this.bucketPath + IN_USE_EXT);
        Path dstPath = new Path(this.bucketPath);
        if (this.fileSystem.exists(srcPath)) {
            LOG.info("Renaming " + srcPath + " to " + dstPath);
            this.fileSystem.rename(srcPath, dstPath);
        }
    }

    public String toString() {
        return "[ " + this.getClass().getSimpleName() + " filePath = " + this.filePath + ", bucketPath = " + this.bucketPath + " ]";
    }

    private boolean isBatchComplete() {
        return this.batchCounter == 0L;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }
}

