/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.util;

import java.util.Iterator;
import java.util.List;
import org.apache.flume.util.OrderSelector;
import org.apache.flume.util.SpecificOrderIterator;

public class RoundRobinOrderSelector<T>
extends OrderSelector<T> {
    private int nextHead = 0;

    public RoundRobinOrderSelector(boolean shouldBackOff) {
        super(shouldBackOff);
    }

    @Override
    public Iterator<T> createIterator() {
        List<Integer> activeIndices = this.getIndexList();
        int size = activeIndices.size();
        if (this.nextHead >= size) {
            this.nextHead = 0;
        }
        int begin = this.nextHead++;
        if (this.nextHead == activeIndices.size()) {
            this.nextHead = 0;
        }
        int[] indexOrder = new int[size];
        for (int i = 0; i < size; ++i) {
            indexOrder[i] = activeIndices.get((begin + i) % size);
        }
        return new SpecificOrderIterator(indexOrder, this.getObjects());
    }
}

