/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.channel.file.FlumeEvent;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.proto.ProtosFactory;

class Put
extends TransactionEventRecord {
    private FlumeEvent event;

    Put(Long transactionID, Long logWriteOrderID) {
        super(transactionID, logWriteOrderID);
    }

    Put(Long transactionID, Long logWriteOrderID, FlumeEvent event) {
        this(transactionID, logWriteOrderID);
        this.event = event;
    }

    FlumeEvent getEvent() {
        return this.event;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.event = FlumeEvent.from(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.event.write(out);
    }

    @Override
    void writeProtos(OutputStream out) throws IOException {
        ProtosFactory.Put.Builder putBuilder = ProtosFactory.Put.newBuilder();
        ProtosFactory.FlumeEvent.Builder eventBuilder = ProtosFactory.FlumeEvent.newBuilder();
        Map<String, String> headers = this.event.getHeaders();
        ProtosFactory.FlumeEventHeader.Builder headerBuilder = ProtosFactory.FlumeEventHeader.newBuilder();
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                headerBuilder.clear();
                eventBuilder.addHeaders(headerBuilder.setKey(key).setValue(value).build());
            }
        }
        eventBuilder.setBody(ByteString.copyFrom((byte[])this.event.getBody()));
        putBuilder.setEvent(eventBuilder.build());
        putBuilder.build().writeDelimitedTo(out);
    }

    @Override
    void readProtos(InputStream in) throws IOException {
        ProtosFactory.Put put = ProtosFactory.Put.parseDelimitedFrom(in);
        HashMap headers = Maps.newHashMap();
        ProtosFactory.FlumeEvent protosEvent = put.getEvent();
        for (ProtosFactory.FlumeEventHeader header : protosEvent.getHeadersList()) {
            headers.put(header.getKey(), header.getValue());
        }
        this.event = new FlumeEvent(headers, protosEvent.getBody().toByteArray());
    }

    @Override
    public short getRecordType() {
        return TransactionEventRecord.Type.PUT.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Put [event=");
        builder.append(this.event);
        builder.append(", getLogWriteOrderID()=");
        builder.append(this.getLogWriteOrderID());
        builder.append(", getTransactionID()=");
        builder.append(this.getTransactionID());
        builder.append("]");
        return builder.toString();
    }
}

