/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flume.channel.file.EventQueueBackingStoreFile;
import org.apache.flume.channel.file.Pair;

final class EventQueueBackingStoreFileV2
extends EventQueueBackingStoreFile {
    private static final int INDEX_SIZE = 2;
    private static final int INDEX_HEAD = 3;
    private static final int INDEX_ACTIVE_LOG = 5;
    private static final int MAX_ACTIVE_LOGS = 1024;

    EventQueueBackingStoreFileV2(File checkpointFile, int capacity, String name) throws IOException {
        super(capacity, name, checkpointFile);
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)("capacity must be greater than 0 " + capacity));
        this.setLogWriteOrderID(this.elementsBuffer.get(1));
        this.setSize((int)this.elementsBuffer.get(2));
        this.setHead((int)this.elementsBuffer.get(3));
        int indexMaxLog = 1029;
        for (int i = 5; i < indexMaxLog; ++i) {
            long nextFileCode = this.elementsBuffer.get(i);
            if (nextFileCode == 0L) continue;
            Pair<Integer, Integer> idAndCount = this.deocodeActiveLogCounter(nextFileCode);
            this.logFileIDReferenceCounts.put(idAndCount.getLeft(), new AtomicInteger(idAndCount.getRight()));
        }
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    protected void incrementFileID(int fileID) {
        super.incrementFileID(fileID);
        Preconditions.checkState((this.logFileIDReferenceCounts.size() < 1024 ? 1 : 0) != 0, (Object)"Too many active logs ");
    }

    private Pair<Integer, Integer> deocodeActiveLogCounter(long value) {
        int fileId = (int)(value >>> 32);
        int count = (int)value;
        return Pair.of(fileId, count);
    }

    private long encodeActiveLogCounter(int fileId, int count) {
        long result = fileId;
        result = (long)fileId << 32;
        return result += (long)count;
    }

    @Override
    protected void writeCheckpointMetaData() {
        int i;
        this.elementsBuffer.put(2, this.getSize());
        this.elementsBuffer.put(3, this.getHead());
        ArrayList<Long> fileIdAndCountEncoded = new ArrayList<Long>();
        for (Integer fileId : this.logFileIDReferenceCounts.keySet()) {
            Integer count = ((AtomicInteger)this.logFileIDReferenceCounts.get(fileId)).get();
            long value = this.encodeActiveLogCounter(fileId, count);
            fileIdAndCountEncoded.add(value);
        }
        int emptySlots = 1024 - fileIdAndCountEncoded.size();
        for (i = 0; i < emptySlots; ++i) {
            fileIdAndCountEncoded.add(0L);
        }
        for (i = 0; i < 1024; ++i) {
            this.elementsBuffer.put(i + 5, (Long)fileIdAndCountEncoded.get(i));
        }
    }
}

