/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flume.channel.file.EventQueueBackingStore;
import org.apache.flume.channel.file.EventQueueBackingStoreFactory;
import org.apache.flume.channel.file.FlumeEventQueue;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.WriteOrderOracle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EventQueueBackingStoreFile
extends EventQueueBackingStore {
    private static final Logger LOG = LoggerFactory.getLogger(EventQueueBackingStoreFile.class);
    private static final int MAX_ALLOC_BUFFER_SIZE = 0x200000;
    protected static final int HEADER_SIZE = 1029;
    protected static final int INDEX_VERSION = 0;
    protected static final int INDEX_WRITE_ORDER_ID = 1;
    protected static final int INDEX_CHECKPOINT_MARKER = 4;
    protected static final int CHECKPOINT_COMPLETE = 0;
    protected static final int CHECKPOINT_INCOMPLETE = 1;
    protected LongBuffer elementsBuffer;
    protected final Map<Integer, Long> overwriteMap = new HashMap<Integer, Long>();
    protected final Map<Integer, AtomicInteger> logFileIDReferenceCounts = Maps.newHashMap();
    protected final MappedByteBuffer mappedBuffer;
    protected final RandomAccessFile checkpointFileHandle;
    protected final File checkpointFile;

    protected EventQueueBackingStoreFile(int capacity, String name, File checkpointFile) throws IOException {
        super(capacity, name);
        this.checkpointFile = checkpointFile;
        this.checkpointFileHandle = new RandomAccessFile(checkpointFile, "rw");
        int totalBytes = (capacity + 1029) * 8;
        if (this.checkpointFileHandle.length() == 0L) {
            EventQueueBackingStoreFile.allocate(checkpointFile, totalBytes);
            this.checkpointFileHandle.seek(0L);
            this.checkpointFileHandle.writeLong(this.getVersion());
            this.checkpointFileHandle.getChannel().force(true);
            LOG.info("Preallocated " + checkpointFile + " to " + this.checkpointFileHandle.length() + " for capacity " + capacity);
        }
        if (checkpointFile.length() != (long)totalBytes) {
            String msg = "Configured capacity is " + capacity + " but the " + " checkpoint file capacity is " + (checkpointFile.length() / 8L - 1029L) + ". See FileChannel documentation on how to change a channels" + " capacity.";
            throw new IllegalStateException(msg);
        }
        this.mappedBuffer = this.checkpointFileHandle.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, checkpointFile.length());
        this.elementsBuffer = this.mappedBuffer.asLongBuffer();
        int version = (int)this.elementsBuffer.get(0);
        Preconditions.checkState((version == this.getVersion() ? 1 : 0) != 0, (Object)("Invalid version: " + version + " " + name + ", expected " + this.getVersion()));
        long checkpointComplete = (int)this.elementsBuffer.get(4);
        Preconditions.checkState((checkpointComplete == 0L ? 1 : 0) != 0, (Object)("The last checkpoint was not completed correctly. Please delete the checkpoint files: " + checkpointFile + " and " + Serialization.getMetaDataFile(checkpointFile) + " to rebuild the checkpoint and start again. " + name));
    }

    protected long getCheckpointLogWriteOrderID() {
        return this.elementsBuffer.get(1);
    }

    protected abstract void writeCheckpointMetaData() throws IOException;

    @Override
    void checkpoint() throws IOException {
        LOG.info("Start checkpoint for " + this.checkpointFile + ", elements to sync = " + this.overwriteMap.size());
        this.elementsBuffer.put(4, 1L);
        this.mappedBuffer.force();
        this.setLogWriteOrderID(WriteOrderOracle.next());
        LOG.info("Updating checkpoint metadata: logWriteOrderID: " + this.getLogWriteOrderID() + ", queueSize: " + this.getSize() + ", queueHead: " + this.getHead());
        this.elementsBuffer.put(1, this.getLogWriteOrderID());
        try {
            this.writeCheckpointMetaData();
        }
        catch (IOException e) {
            throw new IOException("Error writing metadata", e);
        }
        Iterator<Integer> it = this.overwriteMap.keySet().iterator();
        while (it.hasNext()) {
            int index = it.next();
            long value = this.overwriteMap.get(index);
            this.elementsBuffer.put(index, value);
            it.remove();
        }
        Preconditions.checkState((boolean)this.overwriteMap.isEmpty(), (Object)"concurrent update detected ");
        this.elementsBuffer.put(4, 0L);
        this.mappedBuffer.force();
    }

    @Override
    void close() {
        this.mappedBuffer.force();
        try {
            this.checkpointFileHandle.close();
        }
        catch (IOException e) {
            LOG.info("Error closing " + this.checkpointFile, (Throwable)e);
        }
    }

    @Override
    long get(int index) {
        int realIndex = this.getPhysicalIndex(index);
        long result = 0L;
        result = this.overwriteMap.containsKey(realIndex) ? this.overwriteMap.get(realIndex).longValue() : this.elementsBuffer.get(realIndex);
        return result;
    }

    @Override
    ImmutableSortedSet<Integer> getReferenceCounts() {
        return ImmutableSortedSet.copyOf(this.logFileIDReferenceCounts.keySet());
    }

    @Override
    void put(int index, long value) {
        int realIndex = this.getPhysicalIndex(index);
        this.overwriteMap.put(realIndex, value);
    }

    @Override
    boolean syncRequired() {
        return this.overwriteMap.size() > 0;
    }

    @Override
    protected void incrementFileID(int fileID) {
        AtomicInteger counter = this.logFileIDReferenceCounts.get(fileID);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.logFileIDReferenceCounts.put(fileID, counter);
        }
        counter.incrementAndGet();
    }

    @Override
    protected void decrementFileID(int fileID) {
        AtomicInteger counter = this.logFileIDReferenceCounts.get(fileID);
        Preconditions.checkState((counter != null ? 1 : 0) != 0, (Object)"null counter ");
        int count = counter.decrementAndGet();
        if (count == 0) {
            this.logFileIDReferenceCounts.remove(fileID);
        }
    }

    protected int getPhysicalIndex(int index) {
        return 1029 + (this.getHead() + index) % this.getCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void allocate(File file, long totalBytes) throws IOException {
        RandomAccessFile checkpointFile = new RandomAccessFile(file, "rw");
        boolean success = false;
        try {
            if (totalBytes <= 0x200000L) {
                checkpointFile.write(new byte[(int)totalBytes]);
            } else {
                long remainingBytes;
                byte[] initBuffer = new byte[0x200000];
                for (remainingBytes = totalBytes; remainingBytes >= 0x200000L; remainingBytes -= 0x200000L) {
                    checkpointFile.write(initBuffer);
                }
                if (remainingBytes > 0L) {
                    checkpointFile.write(initBuffer, 0, (int)remainingBytes);
                }
            }
            success = true;
        }
        finally {
            block12: {
                try {
                    checkpointFile.close();
                }
                catch (IOException e) {
                    if (!success) break block12;
                    throw e;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        File inflightTakesFile = new File(args[1]);
        File inflightPutsFile = new File(args[2]);
        if (!file.exists()) {
            throw new IOException("File " + file + " does not exist");
        }
        if (file.length() == 0L) {
            throw new IOException("File " + file + " is empty");
        }
        int capacity = (int)((file.length() - 8232L) / 8L);
        EventQueueBackingStoreFile backingStore = (EventQueueBackingStoreFile)EventQueueBackingStoreFactory.get(file, capacity, "debug", false);
        System.out.println("File Reference Counts" + backingStore.logFileIDReferenceCounts);
        System.out.println("Queue Capacity " + backingStore.getCapacity());
        System.out.println("Queue Size " + backingStore.getSize());
        System.out.println("Queue Head " + backingStore.getHead());
        for (int index = 0; index < backingStore.getCapacity(); ++index) {
            long value = backingStore.get(backingStore.getPhysicalIndex(index));
            int fileID = (int)(value >>> 32);
            int offset = (int)value;
            System.out.println(index + ":" + Long.toHexString(value) + " fileID = " + fileID + ", offset = " + offset);
        }
        FlumeEventQueue queue = new FlumeEventQueue(backingStore, inflightTakesFile, inflightPutsFile);
        SetMultimap<Long, Long> putMap = queue.deserializeInflightPuts();
        System.out.println("Inflight Puts:");
        for (Long txnID : putMap.keySet()) {
            Set puts = putMap.get((Object)txnID);
            System.out.println("Transaction ID: " + String.valueOf(txnID));
            Iterator i$ = puts.iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                int fileID = (int)(value >>> 32);
                int offset = (int)value;
                System.out.println(Long.toHexString(value) + " fileID = " + fileID + ", offset = " + offset);
            }
        }
        SetMultimap<Long, Long> takeMap = queue.deserializeInflightTakes();
        System.out.println("Inflight takes:");
        for (Long txnID : takeMap.keySet()) {
            Set takes = takeMap.get((Object)txnID);
            System.out.println("Transaction ID: " + String.valueOf(txnID));
            Iterator i$ = takes.iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                int fileID = (int)(value >>> 32);
                int offset = (int)value;
                System.out.println(Long.toHexString(value) + " fileID = " + fileID + ", offset = " + offset);
            }
        }
    }
}

