/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;

abstract class EventQueueBackingStore {
    protected static final int EMPTY = 0;
    private int queueSize;
    private int queueHead;
    private long logWriteOrderID;
    private final int capacity;
    private final String name;

    protected EventQueueBackingStore(int capacity, String name) {
        this.capacity = capacity;
        this.name = name;
    }

    abstract void checkpoint() throws IOException;

    abstract void incrementFileID(int var1);

    abstract void decrementFileID(int var1);

    abstract ImmutableSortedSet<Integer> getReferenceCounts();

    abstract long get(int var1);

    abstract void put(int var1, long var2);

    abstract boolean syncRequired();

    abstract void close() throws IOException;

    protected abstract int getVersion();

    int getSize() {
        return this.queueSize;
    }

    void setSize(int size) {
        this.queueSize = size;
    }

    int getHead() {
        return this.queueHead;
    }

    void setHead(int head) {
        this.queueHead = head;
    }

    int getCapacity() {
        return this.capacity;
    }

    String getName() {
        return this.name;
    }

    protected void setLogWriteOrderID(long logWriteOrderID) {
        this.logWriteOrderID = logWriteOrderID;
    }

    long getLogWriteOrderID() {
        return this.logWriteOrderID;
    }
}

