/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.recoverable.memory.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class WALEntry<T extends Writable>
implements Writable {
    private static final int MAGIC_HEADER = -559038737;
    private T data;
    private long sequenceID;

    WALEntry(T data) {
        this(data, -1L);
    }

    public WALEntry(T data, long sequenceID) {
        this.data = data;
        this.sequenceID = sequenceID;
    }

    public void readFields(DataInput in) throws IOException {
        int header = in.readInt();
        if (header != -559038737) {
            throw new IOException("Header is " + Integer.toHexString(header) + " expected " + Integer.toHexString(-559038737));
        }
        this.sequenceID = in.readLong();
        this.data.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(-559038737);
        out.writeLong(this.sequenceID);
        this.data.write(out);
    }

    public T getData() {
        return this.data;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    static int getBaseSize() {
        int base = 12;
        return base;
    }
}

