/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.recoverable.memory;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.event.SimpleEvent;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class RecoverableMemoryChannelEvent
implements Event,
Writable {
    Event event;
    long sequenceId;

    private RecoverableMemoryChannelEvent() {
        this.event = new SimpleEvent();
    }

    RecoverableMemoryChannelEvent(Event event, long sequenceId) {
        this.event = event;
        this.sequenceId = sequenceId;
    }

    public Map<String, String> getHeaders() {
        return this.event.getHeaders();
    }

    public void setHeaders(Map<String, String> headers) {
        this.event.setHeaders(headers);
    }

    public byte[] getBody() {
        return this.event.getBody();
    }

    public void setBody(byte[] body) {
        this.event.setBody(body);
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.sequenceId);
        MapWritable map = this.toMapWritable(this.getHeaders());
        map.write(out);
        byte[] body = this.getBody();
        if (body == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(body.length);
            out.write(body);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.sequenceId = in.readLong();
        MapWritable map = new MapWritable();
        map.readFields(in);
        this.setHeaders(this.fromMapWritable(map));
        byte[] body = null;
        int bodyLength = in.readInt();
        if (bodyLength != -1) {
            body = new byte[bodyLength];
            in.readFully(body);
        }
        this.setBody(body);
    }

    private MapWritable toMapWritable(Map<String, String> map) {
        MapWritable result = new MapWritable();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.put((Writable)new Text(entry.getKey()), (Writable)new Text(entry.getValue()));
            }
        }
        return result;
    }

    private Map<String, String> fromMapWritable(MapWritable map) {
        HashMap result = Maps.newHashMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                result.put(((Writable)entry.getKey()).toString(), ((Writable)entry.getValue()).toString());
            }
        }
        return result;
    }
}

