/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.irc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.sink.AbstractSink;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(IRCSink.class);
    private static final int DEFAULT_PORT = 6667;
    private static final String DEFAULT_SPLIT_CHARS = "\n";
    private static final String IRC_CHANNEL_PREFIX = "#";
    private IRCConnection connection = null;
    private String hostname;
    private Integer port;
    private String nick;
    private String password;
    private String user;
    private String name;
    private String chan;
    private Boolean splitLines;
    private String splitChars;
    private CounterGroup counterGroup = new CounterGroup();

    public void configure(Context context) {
        this.hostname = context.getString("hostname");
        String portStr = context.getString("port");
        this.nick = context.getString("nick");
        this.password = context.getString("password");
        this.user = context.getString("user");
        this.name = context.getString("name");
        this.chan = context.getString("chan");
        this.splitLines = context.getBoolean("splitlines");
        this.splitChars = context.getString("splitchars");
        this.port = portStr != null ? Integer.valueOf(Integer.parseInt(portStr)) : Integer.valueOf(6667);
        if (this.splitChars == null) {
            this.splitChars = DEFAULT_SPLIT_CHARS;
        }
        Preconditions.checkState((this.hostname != null ? 1 : 0) != 0, (Object)"No hostname specified");
        Preconditions.checkState((this.nick != null ? 1 : 0) != 0, (Object)"No nick specified");
        Preconditions.checkState((this.chan != null ? 1 : 0) != 0, (Object)"No chan specified");
    }

    private void createConnection() throws IOException {
        if (this.connection == null) {
            logger.debug("Creating new connection to hostname:{} port:{}", (Object)this.hostname, (Object)this.port);
            this.connection = new IRCConnection(this.hostname, new int[]{this.port}, this.password, this.nick, this.user, this.name);
            this.connection.addIRCEventListener((IRCEventListener)new IRCConnectionListener());
            this.connection.setEncoding("UTF-8");
            this.connection.setPong(true);
            this.connection.setDaemon(false);
            this.connection.setColors(false);
            this.connection.connect();
            this.connection.send("join #" + this.chan);
        }
    }

    private void destroyConnection() {
        if (this.connection != null) {
            logger.debug("Destroying connection to: {}:{}", (Object)this.hostname, (Object)this.port);
            this.connection.close();
        }
        this.connection = null;
    }

    public void start() {
        logger.info("IRC sink starting");
        try {
            this.createConnection();
        }
        catch (Exception e) {
            logger.error("Unable to create irc client using hostname:" + this.hostname + " port:" + this.port + ". Exception follows.", (Throwable)e);
            this.destroyConnection();
            return;
        }
        super.start();
        logger.debug("IRC sink {} started", (Object)this.getName());
    }

    public void stop() {
        logger.info("IRC sink {} stopping", (Object)this.getName());
        this.destroyConnection();
        super.stop();
        logger.debug("IRC sink {} stopped. Metrics:{}", (Object)this.getName(), (Object)this.counterGroup);
    }

    private void sendLine(Event event) {
        String body = new String(event.getBody());
        if (this.splitLines.booleanValue()) {
            String[] lines;
            for (String line : lines = body.split(this.splitChars)) {
                this.connection.doPrivmsg(IRC_CHANNEL_PREFIX + this.chan, line);
            }
        } else {
            this.connection.doPrivmsg(IRC_CHANNEL_PREFIX + this.chan, body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction transaction = channel.getTransaction();
        try {
            transaction.begin();
            this.createConnection();
            Event event = channel.take();
            if (event == null) {
                this.counterGroup.incrementAndGet("event.empty");
                status = Sink.Status.BACKOFF;
            } else {
                this.sendLine(event);
                this.counterGroup.incrementAndGet("event.irc");
            }
            transaction.commit();
        }
        catch (ChannelException e) {
            transaction.rollback();
            logger.error("Unable to get event from channel. Exception follows.", (Throwable)e);
            status = Sink.Status.BACKOFF;
        }
        catch (Exception e) {
            transaction.rollback();
            logger.error("Unable to communicate with IRC server. Exception follows.", (Throwable)e);
            status = Sink.Status.BACKOFF;
            this.destroyConnection();
        }
        finally {
            transaction.close();
        }
        return status;
    }

    public static class IRCConnectionListener
    implements IRCEventListener {
        public void onRegistered() {
        }

        public void onDisconnected() {
            logger.error("IRC sink disconnected");
        }

        public void onError(String msg) {
            logger.error("IRC sink error: {}", (Object)msg);
        }

        public void onError(int num, String msg) {
            logger.error("IRC sink error: {} - {}", (Object)num, (Object)msg);
        }

        public void onInvite(String chan, IRCUser u, String nickPass) {
        }

        public void onJoin(String chan, IRCUser u) {
        }

        public void onKick(String chan, IRCUser u, String nickPass, String msg) {
        }

        public void onMode(IRCUser u, String nickPass, String mode) {
        }

        public void onMode(String chan, IRCUser u, IRCModeParser mp) {
        }

        public void onNick(IRCUser u, String nickNew) {
        }

        public void onNotice(String target, IRCUser u, String msg) {
        }

        public void onPart(String chan, IRCUser u, String msg) {
        }

        public void onPrivmsg(String chan, IRCUser u, String msg) {
        }

        public void onQuit(IRCUser u, String msg) {
        }

        public void onReply(int num, String value, String msg) {
        }

        public void onTopic(String chan, IRCUser u, String topic) {
        }

        public void onPing(String p) {
        }

        public void unknown(String a, String b, String c, String d) {
        }
    }
}

