/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.testutils.function;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.StatefulFunction;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.testutils.function.TestContext;

public class FunctionTestHarness {
    private final TestContext context;

    public static FunctionTestHarness test(StatefulFunctionProvider provider, FunctionType type, String id, Instant startTime) {
        Objects.requireNonNull(provider, "Function provider can not be null");
        return new FunctionTestHarness(provider.functionOfType(type), type, id, startTime);
    }

    public static FunctionTestHarness test(StatefulFunctionProvider provider, FunctionType type, String id) {
        Objects.requireNonNull(provider, "Function provider can not be null");
        return new FunctionTestHarness(provider.functionOfType(type), type, id, Instant.EPOCH);
    }

    private FunctionTestHarness(StatefulFunction function, FunctionType type, String id, Instant startTime) {
        this.context = new TestContext(new Address(type, id), function, startTime);
    }

    public Map<Address, List<Object>> invoke(Object message) {
        return this.context.invoke(null, message);
    }

    public Map<Address, List<Object>> invoke(Address from, Object message) {
        Objects.requireNonNull(from);
        return this.context.invoke(from, message);
    }

    public Map<Address, List<Object>> tick(Duration duration) {
        Objects.requireNonNull(duration);
        return this.context.tick(duration);
    }

    public <T> List<T> getEgress(EgressIdentifier<T> identifier) {
        return this.context.getEgress(identifier);
    }
}

