/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.testutils.matchers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.testutils.matchers.MatchersByAddress;
import org.apache.flink.statefun.testutils.matchers.MessagesSentToAddress;
import org.apache.flink.statefun.testutils.matchers.SentNothingMatcher;
import org.hamcrest.Matcher;

public final class StatefulFunctionMatchers {
    private StatefulFunctionMatchers() {
        throw new AssertionError();
    }

    public static MatchersByAddress messagesTo(Address to, Matcher<?> matcher, Matcher<?> ... matchers) {
        ArrayList allMatchers = new ArrayList(1 + matchers.length);
        allMatchers.add(matcher);
        allMatchers.addAll(Arrays.asList(matchers));
        return new MatchersByAddress(to, allMatchers);
    }

    public static MessagesSentToAddress sent(MatchersByAddress matcher, MatchersByAddress ... matchers) {
        HashMap messagesByAddress = new HashMap();
        messagesByAddress.put(matcher.address, matcher.matchers);
        for (MatchersByAddress match : matchers) {
            messagesByAddress.put(match.address, match.matchers);
        }
        return new MessagesSentToAddress(messagesByAddress);
    }

    public static SentNothingMatcher sentNothing() {
        return new SentNothingMatcher();
    }
}

