/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.examples.ridesharing;

import org.apache.flink.statefun.examples.ridesharing.FnDriver;
import org.apache.flink.statefun.examples.ridesharing.FnGeoCell;
import org.apache.flink.statefun.examples.ridesharing.FnPassenger;
import org.apache.flink.statefun.examples.ridesharing.generated.DriverInCell;
import org.apache.flink.statefun.examples.ridesharing.generated.DriverJoinsRide;
import org.apache.flink.statefun.examples.ridesharing.generated.DriverRejectsPickup;
import org.apache.flink.statefun.examples.ridesharing.generated.GetDriver;
import org.apache.flink.statefun.examples.ridesharing.generated.PassengerJoinsRide;
import org.apache.flink.statefun.examples.ridesharing.generated.PickupPassenger;
import org.apache.flink.statefun.examples.ridesharing.generated.RideEnded;
import org.apache.flink.statefun.examples.ridesharing.generated.RideFailed;
import org.apache.flink.statefun.examples.ridesharing.generated.RideStarted;
import org.apache.flink.statefun.sdk.Context;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.annotations.Persisted;
import org.apache.flink.statefun.sdk.match.MatchBinder;
import org.apache.flink.statefun.sdk.match.StatefulMatchFunction;
import org.apache.flink.statefun.sdk.state.PersistedValue;

final class FnRide
extends StatefulMatchFunction {
    static final FunctionType TYPE = new FunctionType("org.apache.flink.statefun.examples.ridesharing", "ride");
    @Persisted
    private final PersistedValue<PassengerJoinsRide> passenger = PersistedValue.of((String)"passenger", PassengerJoinsRide.class);
    @Persisted
    private final PersistedValue<String> driver = PersistedValue.of((String)"driver", String.class);

    FnRide() {
    }

    public void configure(MatchBinder binder) {
        binder.predicate(PassengerJoinsRide.class, this::whenPassengerJoins).predicate(DriverInCell.class, this::whenGeoCellResponds).predicate(DriverRejectsPickup.class, this::whenDriverRejectsPickup).predicate(DriverJoinsRide.class, this::whenDriverJoins).predicate(RideStarted.class, this::whenRideHasStarted).predicate(RideEnded.class, this::whenRideHasEnded);
    }

    private void whenPassengerJoins(Context context, PassengerJoinsRide in) {
        String cellKey = String.valueOf(in.getStartGeoCell());
        this.passenger.set((Object)in);
        context.send(FnGeoCell.TYPE, cellKey, (Object)GetDriver.getDefaultInstance());
    }

    private void whenGeoCellResponds(Context context, DriverInCell in) {
        String driverId = in.getDriverId();
        PassengerJoinsRide rideRequest = (PassengerJoinsRide)this.passenger.get();
        if (driverId != null && !driverId.isEmpty()) {
            context.send(FnDriver.TYPE, driverId, (Object)PickupPassenger.newBuilder().setPassengerId(rideRequest.getPassengerId()).setPassengerStartCell(rideRequest.getStartGeoCell()).setPassengerEndCell(rideRequest.getEndGeoCell()).build());
            return;
        }
        context.send(FnPassenger.TYPE, rideRequest.getPassengerId(), (Object)RideFailed.getDefaultInstance());
        this.passenger.clear();
    }

    private void whenDriverRejectsPickup(Context context, DriverRejectsPickup ignored) {
        int startGeoCell = ((PassengerJoinsRide)this.passenger.get()).getStartGeoCell();
        String cellKey = String.valueOf(startGeoCell);
        context.send(FnGeoCell.TYPE, cellKey, (Object)GetDriver.getDefaultInstance());
    }

    private void whenDriverJoins(Context context, DriverJoinsRide driverJoinRide) {
        this.driver.set((Object)context.caller().id());
        context.send(FnPassenger.TYPE, ((PassengerJoinsRide)this.passenger.get()).getPassengerId(), (Object)driverJoinRide);
    }

    private void whenRideHasStarted(Context context, RideStarted rideStarted) {
        context.send(FnPassenger.TYPE, ((PassengerJoinsRide)this.passenger.get()).getPassengerId(), (Object)rideStarted);
    }

    private void whenRideHasEnded(Context context, RideEnded rideEnded) {
        context.send(FnPassenger.TYPE, ((PassengerJoinsRide)this.passenger.get()).getPassengerId(), (Object)rideEnded);
        this.passenger.clear();
        this.driver.clear();
    }
}

