/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.examples.ridesharing;

import org.apache.flink.statefun.examples.ridesharing.generated.DriverInCell;
import org.apache.flink.statefun.examples.ridesharing.generated.GeoCellState;
import org.apache.flink.statefun.examples.ridesharing.generated.GetDriver;
import org.apache.flink.statefun.examples.ridesharing.generated.JoinCell;
import org.apache.flink.statefun.examples.ridesharing.generated.LeaveCell;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.Context;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.StatefulFunction;
import org.apache.flink.statefun.sdk.annotations.Persisted;
import org.apache.flink.statefun.sdk.state.PersistedValue;

public class FnGeoCell
implements StatefulFunction {
    static final FunctionType TYPE = new FunctionType("org.apache.flink.statefun.examples.ridesharing", "geo-cell");
    @Persisted
    private final PersistedValue<GeoCellState> drivers = PersistedValue.of((String)"drivers", GeoCellState.class);

    public void invoke(Context context, Object input) {
        Address caller = context.caller();
        if (input instanceof JoinCell) {
            this.addDriver(caller);
        } else if (input instanceof LeaveCell) {
            this.removeDriver(caller);
        } else if (input instanceof GetDriver) {
            this.getDriver(context);
        } else {
            throw new IllegalStateException("Unknown message type " + input);
        }
    }

    private void getDriver(Context context) {
        GeoCellState state = (GeoCellState)this.drivers.get();
        if (this.hasDriver(state)) {
            String nextDriverId = (String)state.getDriverIdList().get(0);
            context.reply((Object)DriverInCell.newBuilder().setDriverId(nextDriverId).build());
        } else {
            context.reply((Object)DriverInCell.newBuilder().build());
        }
    }

    private void addDriver(Address driver) {
        GeoCellState state = (GeoCellState)this.drivers.get();
        state = state == null ? GeoCellState.newBuilder().addDriverId(driver.id()).build() : state.toBuilder().addDriverId(driver.id()).build();
        this.drivers.set((Object)state);
    }

    private void removeDriver(Address driver) {
        GeoCellState state = (GeoCellState)this.drivers.get();
        if (state == null) {
            return;
        }
        GeoCellState.Builder nextState = state.toBuilder();
        nextState.clearDriverId();
        for (String otherDriverID : state.getDriverIdList()) {
            if (otherDriverID.equals(driver.id())) continue;
            nextState.addDriverId(otherDriverID);
        }
        this.drivers.set((Object)nextState.build());
    }

    private boolean hasDriver(GeoCellState registeredDrivers) {
        return registeredDrivers != null && !registeredDrivers.getDriverIdList().isEmpty();
    }
}

