/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.examples.ridesharing;

import org.apache.flink.statefun.examples.ridesharing.FnGeoCell;
import org.apache.flink.statefun.examples.ridesharing.FnRide;
import org.apache.flink.statefun.examples.ridesharing.Identifiers;
import org.apache.flink.statefun.examples.ridesharing.generated.DriverJoinsRide;
import org.apache.flink.statefun.examples.ridesharing.generated.DriverRejectsPickup;
import org.apache.flink.statefun.examples.ridesharing.generated.InboundDriverMessage;
import org.apache.flink.statefun.examples.ridesharing.generated.JoinCell;
import org.apache.flink.statefun.examples.ridesharing.generated.LeaveCell;
import org.apache.flink.statefun.examples.ridesharing.generated.OutboundDriverMessage;
import org.apache.flink.statefun.examples.ridesharing.generated.PickupPassenger;
import org.apache.flink.statefun.examples.ridesharing.generated.RideEnded;
import org.apache.flink.statefun.examples.ridesharing.generated.RideStarted;
import org.apache.flink.statefun.sdk.Context;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.annotations.Persisted;
import org.apache.flink.statefun.sdk.match.MatchBinder;
import org.apache.flink.statefun.sdk.match.StatefulMatchFunction;
import org.apache.flink.statefun.sdk.state.PersistedValue;

public class FnDriver
extends StatefulMatchFunction {
    static final FunctionType TYPE = new FunctionType("org.apache.flink.statefun.examples.ridesharing", "driver");
    @Persisted
    private final PersistedValue<String> currentRideId = PersistedValue.of((String)"ride", String.class);
    @Persisted
    private final PersistedValue<Integer> location = PersistedValue.of((String)"location", Integer.class);

    public void configure(MatchBinder binder) {
        binder.predicate(PickupPassenger.class, this::whenPickupIsNeeded).predicate(InboundDriverMessage.class, InboundDriverMessage::hasRideStarted, this::whenRideHasStarted).predicate(InboundDriverMessage.class, InboundDriverMessage::hasRideEnded, this::whenRideHasEnded).predicate(InboundDriverMessage.class, InboundDriverMessage::hasLocationUpdate, this::whenLocationIsUpdated);
    }

    private void whenPickupIsNeeded(Context context, PickupPassenger pickupPassenger) {
        if (this.isTaken()) {
            context.reply((Object)DriverRejectsPickup.newBuilder().setDriverId(context.self().id()).setRideId(context.caller().id()).build());
            return;
        }
        this.currentRideId.set((Object)context.caller().id());
        int currentLocation = (Integer)this.location.getOrDefault((Object)0);
        context.send(FnGeoCell.TYPE, String.valueOf(currentLocation), (Object)LeaveCell.getDefaultInstance());
        context.reply((Object)DriverJoinsRide.newBuilder().setDriverId(context.self().id()).setDriverLocation(currentLocation).build());
        context.send(Identifiers.TO_OUTBOUND_DRIVER, (Object)OutboundDriverMessage.newBuilder().setDriverId(context.self().id()).setPickupPassenger(OutboundDriverMessage.PickupPassenger.newBuilder().setRideId(pickupPassenger.getPassengerId()).setStartGeoLocation(pickupPassenger.getPassengerStartCell()).setEndGeoLocation(pickupPassenger.getPassengerEndCell()).build()).build());
    }

    private void whenRideHasStarted(Context context, InboundDriverMessage ignored) {
        context.send(FnRide.TYPE, (String)this.currentRideId.get(), (Object)RideStarted.newBuilder().setDriverId(context.self().id()).setDriverGeoCell(((Integer)this.location.get()).intValue()).build());
    }

    private void whenRideHasEnded(Context context, InboundDriverMessage ignored) {
        context.send(FnRide.TYPE, (String)this.currentRideId.get(), (Object)RideEnded.getDefaultInstance());
        this.currentRideId.clear();
        Integer currentLocation = (Integer)this.location.get();
        context.send(FnGeoCell.TYPE, String.valueOf(currentLocation), (Object)JoinCell.getDefaultInstance());
    }

    private void whenLocationIsUpdated(Context context, InboundDriverMessage locationUpdate) {
        int updated = locationUpdate.getLocationUpdate().getCurrentGeoCell();
        int last = (Integer)this.location.getOrDefault((Object)-1);
        if (last == -1) {
            this.location.set((Object)updated);
            context.send(FnGeoCell.TYPE, String.valueOf(updated), (Object)JoinCell.getDefaultInstance());
            return;
        }
        if (last == updated) {
            return;
        }
        this.location.set((Object)updated);
    }

    private boolean isTaken() {
        String rideId = (String)this.currentRideId.get();
        return rideId != null;
    }
}

