/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.state.processor.union;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.util.Preconditions;

public class TaggedBootstrapData {
    private static final Address DEFAULT_ADDRESS = new Address(new FunctionType("apache", "DEFAULT"), "DEFAULT");
    private static final Object DEFAULT_PAYLOAD = "DEFAULT_PAYLOAD";
    private static final int DEFAULT_UNION_INDEX = 0;
    private Address target;
    private Object payload;
    private int unionIndex;

    public static TaggedBootstrapData createDefaultInstance() {
        return new TaggedBootstrapData(DEFAULT_ADDRESS, DEFAULT_PAYLOAD, 0);
    }

    public TaggedBootstrapData(Address target, Object payload, int unionIndex) {
        this.target = Objects.requireNonNull(target);
        this.payload = Objects.requireNonNull(payload);
        Preconditions.checkArgument((unionIndex >= 0 ? 1 : 0) != 0);
        this.unionIndex = unionIndex;
    }

    public Address getTarget() {
        return this.target;
    }

    public void setTarget(Address target) {
        this.target = target;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public int getUnionIndex() {
        return this.unionIndex;
    }

    public void setUnionIndex(int unionIndex) {
        this.unionIndex = unionIndex;
    }

    public TaggedBootstrapData copy(TypeSerializer<Object> payloadSerializer) {
        return new TaggedBootstrapData(new Address(this.target.type(), this.target.id()), payloadSerializer.copy(this.payload), this.unionIndex);
    }
}

