/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.state.processor.operator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.statefun.flink.common.SetContextClassLoader;
import org.apache.flink.statefun.flink.core.state.FlinkStateBinder;
import org.apache.flink.statefun.flink.core.state.PersistedStates;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.flink.state.processor.StateBootstrapFunction;
import org.apache.flink.statefun.flink.state.processor.StateBootstrapFunctionProvider;
import org.apache.flink.statefun.sdk.FunctionType;

public final class StateBootstrapFunctionRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<SerializableFunctionType, StateBootstrapFunctionProvider> stateBootstrapFunctionProviders = new HashMap<SerializableFunctionType, StateBootstrapFunctionProvider>();
    private transient Map<FunctionType, StateBootstrapFunction> registry;

    public void register(FunctionType functionType, StateBootstrapFunctionProvider stateBootstrapFunctionProvider) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot register bootstrap function providers after the registry is initialized.");
        }
        Objects.requireNonNull(functionType);
        Objects.requireNonNull(stateBootstrapFunctionProvider);
        StateBootstrapFunctionProvider previous = this.stateBootstrapFunctionProviders.put(SerializableFunctionType.fromNonSerializable(functionType), stateBootstrapFunctionProvider);
        if (previous == null) {
            return;
        }
        throw new IllegalArgumentException(String.format("A StateBootstrapFunctionProvider for function type %s was previously defined.", functionType));
    }

    public int numRegistrations() {
        return this.stateBootstrapFunctionProviders.size();
    }

    void initialize(State stateAccessor) {
        this.registry = new HashMap<FunctionType, StateBootstrapFunction>(this.stateBootstrapFunctionProviders.size());
        for (Map.Entry<SerializableFunctionType, StateBootstrapFunctionProvider> entry : this.stateBootstrapFunctionProviders.entrySet()) {
            FunctionType functionType = entry.getKey().toNonSerializable();
            StateBootstrapFunction bootstrapFunction = entry.getValue().bootstrapFunctionOfType(functionType);
            FlinkStateBinder stateBinder = new FlinkStateBinder(stateAccessor, functionType);
            this.registry.put(functionType, StateBootstrapFunctionRegistry.bindState(bootstrapFunction, stateBinder));
        }
    }

    @Nullable
    StateBootstrapFunction getBootstrapFunction(FunctionType functionType) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("The registry must be initialized first.");
        }
        return this.registry.get(functionType);
    }

    private static StateBootstrapFunction bindState(StateBootstrapFunction bootstrapFunction, FlinkStateBinder stateBinder) {
        try (SetContextClassLoader ignored = new SetContextClassLoader((Object)bootstrapFunction);){
            PersistedStates.findReflectivelyAndBind((Object)bootstrapFunction, (FlinkStateBinder)stateBinder);
            StateBootstrapFunction stateBootstrapFunction = bootstrapFunction;
            return stateBootstrapFunction;
        }
    }

    private boolean isInitialized() {
        return this.registry != null;
    }

    private static final class SerializableFunctionType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String namespace;
        private final String name;

        static SerializableFunctionType fromNonSerializable(FunctionType functionType) {
            return new SerializableFunctionType(functionType.namespace(), functionType.name());
        }

        private SerializableFunctionType(String namespace, String name) {
            this.namespace = Objects.requireNonNull(namespace);
            this.name = Objects.requireNonNull(name);
        }

        private FunctionType toNonSerializable() {
            return new FunctionType(this.namespace, this.name);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableFunctionType that = (SerializableFunctionType)o;
            return this.namespace.equals(that.namespace) && this.name.equals(that.name);
        }
    }
}

