/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.state.processor.union;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.statefun.flink.state.processor.union.TaggedBootstrapData;
import org.apache.flink.statefun.flink.state.processor.union.TaggedBootstrapDataSerializer;
import org.apache.flink.util.Preconditions;

public final class TaggedBootstrapDataTypeInfo
extends TypeInformation<TaggedBootstrapData> {
    private static final long serialVersionUID = 1L;
    private final List<TypeInformation<?>> payloadTypeInfos;

    TaggedBootstrapDataTypeInfo(List<TypeInformation<?>> payloadTypeInfos) {
        Preconditions.checkNotNull(payloadTypeInfos);
        Preconditions.checkArgument((!payloadTypeInfos.isEmpty() ? 1 : 0) != 0);
        this.payloadTypeInfos = payloadTypeInfos;
    }

    public TypeSerializer<TaggedBootstrapData> createSerializer(ExecutionConfig executionConfig) {
        List<TypeSerializer<?>> payloadSerializers = this.payloadTypeInfos.stream().map(typeInfo -> typeInfo.createSerializer(executionConfig)).collect(Collectors.toList());
        return new TaggedBootstrapDataSerializer(payloadSerializers);
    }

    public int getTotalFields() {
        return 1;
    }

    public int getArity() {
        return 1;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isKeyType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public Class<TaggedBootstrapData> getTypeClass() {
        return TaggedBootstrapData.class;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TaggedBootstrapDataTypeInfo {");
        int size = this.payloadTypeInfos.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this.payloadTypeInfos.get(i).toString());
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean canEqual(Object o) {
        return o instanceof TaggedBootstrapDataTypeInfo;
    }

    public int hashCode() {
        return Objects.hash(this.payloadTypeInfos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TaggedBootstrapDataTypeInfo that = (TaggedBootstrapDataTypeInfo)((Object)o);
        return Objects.equals(this.payloadTypeInfos, that.payloadTypeInfos);
    }
}

