/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.state.processor.union;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.state.processor.union.TaggedBootstrapData;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.util.Preconditions;

public final class TaggedBootstrapDataSerializer
extends TypeSerializer<TaggedBootstrapData> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<Object>[] payloadSerializers;
    private transient Object[] reusablePayloadObjects;

    TaggedBootstrapDataSerializer(List<TypeSerializer<?>> payloadSerializers) {
        Preconditions.checkNotNull(payloadSerializers);
        Preconditions.checkArgument((!payloadSerializers.isEmpty() ? 1 : 0) != 0);
        this.payloadSerializers = TaggedBootstrapDataSerializer.toPayloadSerializerIndexArray(payloadSerializers);
        this.reusablePayloadObjects = TaggedBootstrapDataSerializer.createReusablePayloadObjectsIndexArray(this.payloadSerializers);
    }

    public boolean isImmutableType() {
        for (TypeSerializer<Object> serializer : this.payloadSerializers) {
            if (serializer.isImmutableType()) continue;
            return false;
        }
        return true;
    }

    public TypeSerializer<TaggedBootstrapData> duplicate() {
        ArrayList duplicates = new ArrayList(this.payloadSerializers.length);
        boolean stateful = false;
        for (TypeSerializer<Object> serializer : this.payloadSerializers) {
            TypeSerializer duplicate = serializer.duplicate();
            if (duplicate != serializer) {
                stateful = true;
            }
            duplicates.add(duplicate);
        }
        if (!stateful) {
            return this;
        }
        return new TaggedBootstrapDataSerializer(duplicates);
    }

    public TaggedBootstrapData createInstance() {
        return TaggedBootstrapData.createDefaultInstance();
    }

    public void serialize(TaggedBootstrapData bootstrapData, DataOutputView dataOutputView) throws IOException {
        int unionIndex = bootstrapData.getUnionIndex();
        Address address = bootstrapData.getTarget();
        dataOutputView.writeInt(unionIndex);
        dataOutputView.writeUTF(address.type().namespace());
        dataOutputView.writeUTF(address.type().name());
        dataOutputView.writeUTF(address.id());
        this.payloadSerializers[unionIndex].serialize(bootstrapData.getPayload(), dataOutputView);
    }

    public TaggedBootstrapData deserialize(DataInputView dataInputView) throws IOException {
        int unionIndex = dataInputView.readInt();
        String targetFunctionTypeNamespace = dataInputView.readUTF();
        String targetFunctionTypeName = dataInputView.readUTF();
        String targetFunctionId = dataInputView.readUTF();
        Object payload = this.payloadSerializers[unionIndex].deserialize(dataInputView);
        return new TaggedBootstrapData(new Address(new FunctionType(targetFunctionTypeNamespace, targetFunctionTypeName), targetFunctionId), payload, unionIndex);
    }

    public TaggedBootstrapData deserialize(TaggedBootstrapData reuse, DataInputView dataInputView) throws IOException {
        int unionIndex = dataInputView.readInt();
        String targetFunctionTypeNamespace = dataInputView.readUTF();
        String targetFunctionTypeName = dataInputView.readUTF();
        String targetFunctionId = dataInputView.readUTF();
        reuse.setUnionIndex(unionIndex);
        reuse.setTarget(new Address(new FunctionType(targetFunctionTypeNamespace, targetFunctionTypeName), targetFunctionId));
        reuse.setPayload(this.payloadSerializers[unionIndex].deserialize(this.reusablePayloadObjects[unionIndex], dataInputView));
        return reuse;
    }

    public TaggedBootstrapData copy(TaggedBootstrapData bootstrapData) {
        TypeSerializer<Object> payloadSerializer = this.payloadSerializers[bootstrapData.getUnionIndex()];
        return bootstrapData.copy(payloadSerializer);
    }

    public TaggedBootstrapData copy(TaggedBootstrapData bootstrapData, TaggedBootstrapData reuse) {
        int unionIndex = bootstrapData.getUnionIndex();
        TypeSerializer<Object> payloadSerializer = this.payloadSerializers[unionIndex];
        Object reusedPayloadCopy = payloadSerializer.copy(bootstrapData.getPayload(), this.reusablePayloadObjects[unionIndex]);
        Address address = bootstrapData.getTarget();
        reuse.setTarget(new Address(address.type(), address.id()));
        reuse.setPayload(reusedPayloadCopy);
        reuse.setUnionIndex(bootstrapData.getUnionIndex());
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int unionIndex = source.readInt();
        target.writeInt(unionIndex);
        target.writeUTF(source.readUTF());
        target.writeUTF(source.readUTF());
        target.writeUTF(source.readUTF());
        this.payloadSerializers[unionIndex].copy(source, target);
    }

    public int getLength() {
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TaggedBootstrapDataSerializer that = (TaggedBootstrapDataSerializer)((Object)o);
        return Arrays.equals(this.payloadSerializers, that.payloadSerializers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.payloadSerializers);
    }

    public TypeSerializerSnapshot<TaggedBootstrapData> snapshotConfiguration() {
        throw new UnsupportedOperationException("This serializer should not have been used for any persistent data.");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reusablePayloadObjects = TaggedBootstrapDataSerializer.createReusablePayloadObjectsIndexArray(this.payloadSerializers);
    }

    private static TypeSerializer<Object>[] toPayloadSerializerIndexArray(List<TypeSerializer<?>> payloadSerializers) {
        return payloadSerializers.toArray(new TypeSerializer[0]);
    }

    private static Object[] createReusablePayloadObjectsIndexArray(TypeSerializer<?>[] payloadSerializers) {
        Object[] result = new Object[payloadSerializers.length];
        for (int index = 0; index < payloadSerializers.length; ++index) {
            result[index] = payloadSerializers[index].createInstance();
            ++index;
        }
        return result;
    }
}

