/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.examples.async.service;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.flink.statefun.examples.async.service.TaskQueryService;
import org.apache.flink.statefun.examples.async.service.TaskStatus;

public final class DummyTaskQueryService
implements TaskQueryService {
    private final ScheduledExecutorService executor = DummyTaskQueryService.newScheduledExecutorService();

    @Override
    public CompletableFuture<TaskStatus> getTaskStatusAsync(String taskId) {
        CompletableFuture<TaskStatus> result = new CompletableFuture<TaskStatus>();
        long randomCompletionDelay = ThreadLocalRandom.current().nextLong(5000L);
        this.executor.schedule(DummyTaskQueryService.completeRandomly(taskId, result), randomCompletionDelay, TimeUnit.MILLISECONDS);
        return result;
    }

    private static Runnable completeRandomly(String taskId, CompletableFuture<TaskStatus> result) {
        return () -> {
            boolean taskStatus = ThreadLocalRandom.current().nextBoolean();
            if (taskStatus) {
                long now = System.currentTimeMillis();
                result.complete(new TaskStatus(taskId, true, now));
            } else {
                result.complete(new TaskStatus(taskId, false, null));
            }
        };
    }

    private static ScheduledExecutorService newScheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
    }
}

