/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.tweetinputformat.io;

import java.io.IOException;
import org.apache.flink.contrib.tweetinputformat.model.tweet.Contributors;
import org.apache.flink.contrib.tweetinputformat.model.tweet.Tweet;
import org.apache.flink.contrib.tweetinputformat.model.tweet.entities.HashTags;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TweetHandler
implements ContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(TweetHandler.class);
    protected Tweet reuse;
    private int nesting = 0;
    private ObjectState objectState = ObjectState.TWEET;
    private EntryState entryState = EntryState.UNEXPECTED;
    private boolean sameHashTag = false;
    private int coordinatesCounter = 0;
    private double coordinatesTemp = 0.0;

    public void startJSON() throws ParseException, IOException {
        this.sameHashTag = true;
    }

    public void endJSON() throws ParseException, IOException {
    }

    public boolean startObject() throws ParseException, IOException {
        ++this.nesting;
        return true;
    }

    public boolean endObject() throws ParseException, IOException {
        --this.nesting;
        if (this.nesting == 1) {
            this.objectState = ObjectState.TWEET;
        }
        return this.nesting > 0;
    }

    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if (key.equals("contributors") || key.equals("user") || key.equals("geo") || key.equals("place") || key.equals("attributes") || key.equals("bounding_box")) {
            this.objectState = ObjectState.valueOf(key.toUpperCase());
        } else if (key.equals("hashtags") && this.nesting == 2) {
            this.objectState = ObjectState.valueOf(key.toUpperCase());
        } else if (key.equals("coordinates") && this.nesting == 1) {
            this.objectState = ObjectState.valueOf(key.toUpperCase());
        } else {
            try {
                this.entryState = EntryState.valueOf(key.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.debug(e.getMessage());
            }
        }
        return true;
    }

    public boolean endObjectEntry() throws ParseException, IOException {
        if (this.objectState == ObjectState.CONTRIBUTORS && this.nesting == 1) {
            this.objectState = ObjectState.TWEET;
        }
        return true;
    }

    public boolean startArray() throws ParseException, IOException {
        return true;
    }

    public boolean endArray() throws ParseException, IOException {
        if (this.objectState == ObjectState.COORDINATES) {
            this.coordinatesCounter = 0;
            this.coordinatesTemp = 0.0;
        }
        if (this.objectState == ObjectState.HASHTAGS && this.entryState == EntryState.INDICES && this.nesting == 2) {
            this.sameHashTag = false;
        }
        return true;
    }

    public boolean primitive(Object value) throws ParseException, IOException {
        try {
            if (this.objectState == ObjectState.TWEET) {
                this.tweetObjectStatePrimitiveHandler(value);
            } else if (this.objectState == ObjectState.USER) {
                this.userObjectStatePrimitiveHandler(value);
            } else {
                if (this.objectState == ObjectState.GEO) {
                    return true;
                }
                if (this.objectState == ObjectState.COORDINATES) {
                    this.coordinatesObjectStatePrimitiveHandler(value);
                } else if (this.objectState == ObjectState.PLACE) {
                    this.placeObjectStatePrimitiveHandler(value);
                } else {
                    if (this.objectState == ObjectState.GEO) {
                        return true;
                    }
                    if (this.objectState == ObjectState.ATTRIBUTES) {
                        this.placeAttributesObjectStatePrimitiveHandler(value);
                    } else if (this.objectState == ObjectState.CONTRIBUTORS) {
                        this.contributorsObjectStatePrimitiveHandler(value);
                    } else if (this.objectState == ObjectState.HASHTAGS && this.entryState == EntryState.TEXT && this.sameHashTag) {
                        this.hashTagsObjectStatePrimitiveHandler(value);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.debug("Error in primitive type:  " + e.getMessage());
        }
        return true;
    }

    public void tweetObjectStatePrimitiveHandler(Object value) {
        switch (this.entryState) {
            case CREATED_AT: {
                if (value == null) break;
                this.reuse.setCreated_at((String)value);
                break;
            }
            case TEXT: {
                if (value == null) break;
                this.reuse.setText((String)value);
                break;
            }
            case ID: {
                if (value == null) break;
                this.reuse.setId((Long)value);
                break;
            }
            case ID_STR: {
                if (value == null) break;
                this.reuse.setId_str((String)value);
                break;
            }
            case SOURCE: {
                if (value == null) break;
                this.reuse.setSource((String)value);
                break;
            }
            case TRUNCATED: {
                if (value == null) break;
                this.reuse.setTruncated((Boolean)value);
                break;
            }
            case IN_REPLY_TO_STATUS_ID: {
                if (value == null) break;
                this.reuse.setIn_reply_to_status_id((Long)value);
                break;
            }
            case IN_REPLY_TO_STATUS_ID_STR: {
                if (value == null) break;
                this.reuse.setIn_reply_to_status_id_str((String)value);
                break;
            }
            case IN_REPLY_TO_USER_ID: {
                if (value == null) break;
                this.reuse.setIn_reply_to_user_id((Long)value);
                break;
            }
            case IN_REPLY_TO_USER_ID_STR: {
                if (value == null) break;
                this.reuse.setIn_reply_to_user_id_str((String)value);
                break;
            }
            case IN_REPLY_TO_SCREEN_NAME: {
                if (value == null) break;
                this.reuse.setIn_reply_to_screen_name((String)value);
                break;
            }
            case RETWEET_COUNT: {
                if (value == null) break;
                this.reuse.setRetweet_count((Long)value);
                break;
            }
            case FAVORITE_COUNT: {
                if (value == null) break;
                this.reuse.setFavorite_count((Long)value);
                break;
            }
            case FAVORITED: {
                if (value == null) break;
                this.reuse.setFavorited((Boolean)value);
                break;
            }
            case RETWEETED: {
                if (value == null) break;
                this.reuse.setRetweeted((Boolean)value);
                break;
            }
            case POSSIBLY_SENSITIVE: {
                if (value == null) break;
                this.reuse.setPossibly_sensitive((Boolean)value);
                break;
            }
            case FILTER_LEVEL: {
                if (value == null) break;
                this.reuse.setFilter_level((String)value);
                break;
            }
            case LANG: {
                if (value == null) break;
                this.reuse.setLang((String)value);
            }
        }
    }

    public void userObjectStatePrimitiveHandler(Object value) {
        switch (this.entryState) {
            case ID: {
                if (value == null) break;
                if (value instanceof String) {
                    try {
                        this.reuse.getUser().setId(Long.parseLong((String)value));
                    }
                    catch (NumberFormatException e) {
                        this.reuse.getUser().setId(0L);
                        logger.debug("This Tweet_ID is not a numeric type : " + (String)value);
                    }
                    break;
                }
                this.reuse.getUser().setId((Long)value);
                break;
            }
            case ID_STR: {
                if (value == null) break;
                this.reuse.getUser().setId_str((String)value);
                break;
            }
            case NAME: {
                if (value == null) break;
                this.reuse.getUser().setName((String)value);
                break;
            }
            case SCREEN_NAME: {
                if (value == null) break;
                this.reuse.getUser().setScreen_name((String)value);
                break;
            }
            case LOCATION: {
                if (value == null) break;
                this.reuse.getUser().setLocation((String)value);
                break;
            }
            case URL: {
                if (value == null) break;
                this.reuse.getUser().setUrl((String)value);
                break;
            }
            case DESCRIPTION: {
                if (value == null) break;
                this.reuse.getUser().setDescription((String)value);
                break;
            }
            case PROTECTED: {
                if (value == null) break;
                this.reuse.getUser().setProtected_tweet((Boolean)value);
                break;
            }
            case VERIFIED: {
                if (value == null) break;
                this.reuse.getUser().setVerified((Boolean)value);
                break;
            }
            case FOLLOWERS_COUNT: {
                if (value == null) break;
                this.reuse.getUser().setFollowers_count((Long)value);
                break;
            }
            case FRIENDS_COUNT: {
                if (value == null) break;
                this.reuse.getUser().setFriends_count((Long)value);
                break;
            }
            case LISTED_COUNT: {
                if (value == null) break;
                this.reuse.getUser().setListed_count((Long)value);
                break;
            }
            case FAVOURITES_COUNT: {
                if (value == null) break;
                this.reuse.getUser().setFavourites_count((Long)value);
                break;
            }
            case STATUSES_COUNT: {
                if (value == null) break;
                this.reuse.getUser().setStatuses_count((Long)value);
                break;
            }
            case CREATED_AT: {
                if (value == null) break;
                this.reuse.getUser().setCreated_at((String)value);
                break;
            }
            case UTC_OFFSET: {
                if (value == null) break;
                this.reuse.getUser().setUtc_offset((Long)value);
                break;
            }
            case TIME_ZONE: {
                if (value == null) break;
                this.reuse.getUser().setTime_zone((String)value);
                break;
            }
            case GEO_ENABLED: {
                if (value == null) break;
                this.reuse.getUser().setGeo_enabled((Boolean)value);
                break;
            }
            case LANG: {
                if (value == null) break;
                this.reuse.getUser().setLang((String)value);
                break;
            }
            case CONTRIBUTORS_ENABLED: {
                if (value == null) break;
                this.reuse.getUser().setContributors_enabled((Boolean)value);
                break;
            }
            case IS_TRANSLATOR: {
                if (value == null) break;
                this.reuse.getUser().setIs_translator((Boolean)value);
                break;
            }
            case PROFILE_BACKGROUND_COLOR: {
                if (value == null) break;
                this.reuse.getUser().setProfile_background_color((String)value);
                break;
            }
            case PROFILE_BACKGROUND_IMAGE_URL: {
                if (value == null) break;
                this.reuse.getUser().setProfile_background_image_url((String)value);
                break;
            }
            case PROFILE_BACKGROUND_IMAGE_URL_HTTPS: {
                if (value == null) break;
                this.reuse.getUser().setProfile_background_image_url_https((String)value);
                break;
            }
            case PROFILE_BACKGROUND_TILE: {
                if (value == null) break;
                this.reuse.getUser().setProfile_background_tile((Boolean)value);
                break;
            }
            case PROFILE_LINK_COLOR: {
                if (value == null) break;
                this.reuse.getUser().setProfile_link_color((String)value);
                break;
            }
            case PROFILE_SIDEBAR_BORDER_COLOR: {
                if (value == null) break;
                this.reuse.getUser().setProfile_sidebar_border_color((String)value);
                break;
            }
            case PROFILE_SIDEBAR_FILL_COLOR: {
                if (value == null) break;
                this.reuse.getUser().setProfile_sidebar_fill_color((String)value);
                break;
            }
            case PROFILE_TEXT_COLOR: {
                if (value == null) break;
                this.reuse.getUser().setProfile_text_color((String)value);
                break;
            }
            case PROFILE_USE_BACKGROUND_IMAGE: {
                if (value == null) break;
                this.reuse.getUser().setProfile_use_background_image((Boolean)value);
                break;
            }
            case PROFILE_IMAGE_URL: {
                if (value == null) break;
                this.reuse.getUser().setProfile_image_url((String)value);
                break;
            }
            case PROFILE_IMAGE_URL_HTTPS: {
                if (value == null) break;
                this.reuse.getUser().setProfile_image_url_https((String)value);
                break;
            }
            case PROFILE_BANNER_URL: {
                if (value == null) break;
                this.reuse.getUser().setProfile_banner_url((String)value);
                break;
            }
            case DEFAULT_PROFILE: {
                if (value == null) break;
                this.reuse.getUser().setDefault_profile((Boolean)value);
                break;
            }
            case DEFAULT_PROFILE_IMAGE: {
                if (value == null) break;
                this.reuse.getUser().setDefault_profile_image((Boolean)value);
                break;
            }
            case FOLLOWING: {
                if (value == null) break;
                this.reuse.getUser().setFollowing((Boolean)value);
                break;
            }
            case FOLLOW_REQUEST_SENT: {
                if (value == null) break;
                this.reuse.getUser().setFollow_request_sent((Boolean)value);
                break;
            }
            case NOTIFICATIONS: {
                if (value == null) break;
                this.reuse.getUser().setNotifications((Boolean)value);
            }
        }
    }

    public void coordinatesObjectStatePrimitiveHandler(Object value) {
        switch (this.entryState) {
            case COORDINATES: {
                if (value != null && this.coordinatesCounter == 0) {
                    this.coordinatesTemp = (Double)value;
                    ++this.coordinatesCounter;
                    break;
                }
                if (value != null && this.coordinatesCounter == 1) {
                    this.reuse.getCoordinates().setCoordinates(this.coordinatesTemp, (Double)value);
                    break;
                }
                this.reuse.getCoordinates().setCoordinates(0.0, 0.0);
            }
        }
    }

    public void placeObjectStatePrimitiveHandler(Object value) {
        switch (this.entryState) {
            case ID: {
                if (value == null) break;
                this.reuse.getPlace().setId((String)value);
                break;
            }
            case URL: {
                if (value == null) break;
                this.reuse.getPlace().setUrl((String)value);
                break;
            }
            case PLACE_TYPE: {
                if (value == null) break;
                this.reuse.getPlace().setPlace_type((String)value);
                break;
            }
            case NAME: {
                if (value == null) break;
                this.reuse.getPlace().setName((String)value);
                break;
            }
            case FULL_NAME: {
                if (value == null) break;
                this.reuse.getPlace().setFull_name((String)value);
                break;
            }
            case COUNTRY_CODE: {
                if (value == null) break;
                this.reuse.getPlace().setCountry_code((String)value);
                break;
            }
            case COUNTRY: {
                if (value == null) break;
                this.reuse.getPlace().setCountry((String)value);
            }
        }
    }

    public void placeAttributesObjectStatePrimitiveHandler(Object value) {
        switch (this.entryState) {
            case STREET_ADDRESS: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setStreet_address((String)value);
                break;
            }
            case LOCALITY: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setLocality((String)value);
                break;
            }
            case REGION: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setRegion((String)value);
                break;
            }
            case ISO3: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setIso3((String)value);
                break;
            }
            case POSTAL_CODE: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setPostal_code((String)value);
                break;
            }
            case PHONE: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setPhone((String)value);
                break;
            }
            case URL: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setUrl((String)value);
                break;
            }
            case APP_ID: {
                if (value == null) break;
                this.reuse.getPlace().getAttributes().setAppId((String)value);
            }
        }
    }

    public void contributorsObjectStatePrimitiveHandler(Object value) {
        if (value == null) {
            this.reuse.getContributors().add(new Contributors());
        } else {
            Contributors contributor = new Contributors();
            switch (this.entryState) {
                case ID: {
                    if (value == null) break;
                    contributor.setId((Long)value);
                    break;
                }
                case ID_STR: {
                    if (value == null) break;
                    contributor.setId_str((String)value);
                    break;
                }
                case TWEET_CONTRIBUTORS_SCREEN_NAME: {
                    if (value == null) break;
                    contributor.setScreenName((String)value);
                }
            }
            this.reuse.getContributors().add(contributor);
        }
    }

    public void hashTagsObjectStatePrimitiveHandler(Object value) {
        HashTags hashTag = new HashTags();
        if (value == null) {
            return;
        }
        if (this.entryState == EntryState.TEXT && value != null) {
            hashTag.setText((String)value, false);
            this.reuse.getEntities().getHashtags().add(hashTag);
        }
    }

    private static enum EntryState {
        TEXT,
        CREATED_AT,
        ID,
        ID_STR,
        SOURCE,
        TRUNCATED,
        IN_REPLY_TO_STATUS_ID,
        IN_REPLY_TO_STATUS_ID_STR,
        IN_REPLY_TO_USER_ID,
        IN_REPLY_TO_USER_ID_STR,
        IN_REPLY_TO_SCREEN_NAME,
        RETWEET_COUNT,
        FAVORITE_COUNT,
        FAVORITED,
        RETWEETED,
        POSSIBLY_SENSITIVE,
        FILTER_LEVEL,
        TWEET_CONTRIBUTORS_SCREEN_NAME,
        SCREEN_NAME,
        LOCATION,
        DESCRIPTION,
        PROTECTED,
        VERIFIED,
        FOLLOWERS_COUNT,
        FRIENDS_COUNT,
        LISTED_COUNT,
        FAVOURITES_COUNT,
        STATUSES_COUNT,
        UTC_OFFSET,
        TIME_ZONE,
        GEO_ENABLED,
        LANG,
        CONTRIBUTORS_ENABLED,
        IS_TRANSLATOR,
        PROFILE_BACKGROUND_COLOR,
        PROFILE_BACKGROUND_IMAGE_URL,
        PROFILE_BACKGROUND_IMAGE_URL_HTTPS,
        PROFILE_BACKGROUND_TILE,
        PROFILE_LINK_COLOR,
        PROFILE_SIDEBAR_BORDER_COLOR,
        PROFILE_SIDEBAR_FILL_COLOR,
        PROFILE_TEXT_COLOR,
        PROFILE_USE_BACKGROUND_IMAGE,
        PROFILE_IMAGE_URL,
        PROFILE_IMAGE_URL_HTTPS,
        PROFILE_BANNER_URL,
        DEFAULT_PROFILE,
        DEFAULT_PROFILE_IMAGE,
        FOLLOWING,
        FOLLOW_REQUEST_SENT,
        NOTIFICATIONS,
        TYPE,
        COORDINATES,
        PLACE_TYPE,
        NAME,
        FULL_NAME,
        COUNTRY_CODE,
        COUNTRY,
        BOUNDING_BOX,
        ATTRIBUTES,
        STREET_ADDRESS,
        LOCALITY,
        REGION,
        ISO3,
        POSTAL_CODE,
        PHONE,
        URL,
        ENTITIES,
        HASHTAGS,
        TRENDS,
        URLS,
        USER_MENTIONS,
        SYMBOLS,
        MEDIA,
        INDICES,
        MEDIA_URL,
        MEDIA_URL_HTTPS,
        DISPLAY_URL,
        EXPANDED_URL,
        SIZES,
        LARGE,
        W,
        H,
        RESIZE,
        SMALL,
        THUMB,
        MEDIUM,
        RETWEETED_STATUS,
        SOURCE_STATUS_ID,
        SOURCE_STATUS_ID_STR,
        SCOPES,
        FOLLOWERS,
        APP_ID,
        UNEXPECTED;

    }

    private static enum ObjectState {
        TWEET,
        CONTRIBUTORS,
        USER,
        GEO,
        COORDINATES,
        PLACE,
        ATTRIBUTES,
        BOUNDING_BOX,
        HASHTAGS;

    }
}

