/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

import org.apache.flink.util.Preconditions;

public final class SessionEvent<K, V> {
    private K sessionKey;
    private V eventValue;
    private long eventTimestamp;

    public SessionEvent() {
    }

    public SessionEvent(K sessionKey, V eventValue, long eventTimestamp) {
        Preconditions.checkNotNull(sessionKey);
        Preconditions.checkNotNull(eventValue);
        this.setSessionKey(sessionKey);
        this.setEventValue(eventValue);
        this.setEventTimestamp(eventTimestamp);
    }

    public K getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(K sessionKey) {
        Preconditions.checkNotNull(sessionKey);
        this.sessionKey = sessionKey;
    }

    public V getEventValue() {
        return this.eventValue;
    }

    public void setEventValue(V eventValue) {
        Preconditions.checkNotNull(eventValue);
        this.eventValue = eventValue;
    }

    public long getEventTimestamp() {
        return this.eventTimestamp;
    }

    public void setEventTimestamp(long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public String toString() {
        return "SessionEvent{sessionKey=" + this.sessionKey + ", eventValue=" + this.eventValue + ", eventTimestamp=" + this.eventTimestamp + "}";
    }

    public static <K, V> SessionEvent<K, V> of(K sessionKey, V eventValue, long eventTimestamp) {
        return new SessionEvent<K, V>(sessionKey, eventValue, eventTimestamp);
    }
}

