/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

import org.apache.flink.test.windowing.sessionwindows.GeneratorEventFactory;
import org.apache.flink.util.Preconditions;

public final class SessionConfiguration<K, E> {
    private final K key;
    private final int sessionId;
    private final long gap;
    private final long minEventTimestamp;
    private final int numberOfTimelyEvents;
    private final GeneratorEventFactory<K, E> eventFactory;

    public SessionConfiguration(K key, int sessionId, long gap, long minEventTimestamp, int numberOfTimelyEvents, GeneratorEventFactory<K, E> eventFactory) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(eventFactory);
        Preconditions.checkArgument((numberOfTimelyEvents > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((gap > 0L ? 1 : 0) != 0);
        this.key = key;
        this.eventFactory = eventFactory;
        this.sessionId = sessionId;
        this.gap = gap;
        this.numberOfTimelyEvents = numberOfTimelyEvents;
        this.minEventTimestamp = minEventTimestamp;
    }

    public K getKey() {
        return this.key;
    }

    public GeneratorEventFactory<K, E> getEventFactory() {
        return this.eventFactory;
    }

    public long getGap() {
        return this.gap;
    }

    public long getMinEventTimestamp() {
        return this.minEventTimestamp;
    }

    public int getNumberOfTimelyEvents() {
        return this.numberOfTimelyEvents;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public static <K, E> SessionConfiguration<K, E> of(K key, int sessionId, long timeout, long startTimestamp, int numberOfEvents, GeneratorEventFactory<K, E> eventFactory) {
        return new SessionConfiguration<K, E>(key, sessionId, timeout, startTimestamp, numberOfEvents, eventFactory);
    }

    public String toString() {
        return "SessionConfiguration{key=" + this.key + ", sessionId=" + this.sessionId + ", gap=" + this.gap + ", minEventTimestamp=" + this.minEventTimestamp + ", numberOfTimelyEvents=" + this.numberOfTimelyEvents + ", eventFactory=" + this.eventFactory + "}";
    }

    public SessionConfiguration<K, E> getFollowupSessionConfiguration(long startTimestamp) {
        return SessionConfiguration.of(this.getKey(), this.getSessionId() + 1, this.getGap(), startTimestamp, this.getNumberOfTimelyEvents(), this.getEventFactory());
    }
}

