/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

public final class GeneratorConfiguration {
    private final long allowedLateness;
    private final int lateEventsWithinLateness;
    private final int lateEventsAfterLateness;
    private final long maxAdditionalSessionGap;

    public GeneratorConfiguration(long allowedLateness, int lateEventsWithinLateness, int lateEventsAfterLateness, long maxAdditionalSessionGap) {
        this.allowedLateness = allowedLateness;
        this.lateEventsWithinLateness = lateEventsWithinLateness;
        this.lateEventsAfterLateness = lateEventsAfterLateness;
        this.maxAdditionalSessionGap = maxAdditionalSessionGap;
    }

    public long getAllowedLateness() {
        return this.allowedLateness;
    }

    public int getLateEventsWithinLateness() {
        return this.lateEventsWithinLateness;
    }

    public int getLateEventsAfterLateness() {
        return this.lateEventsAfterLateness;
    }

    public long getMaxAdditionalSessionGap() {
        return this.maxAdditionalSessionGap;
    }

    public static GeneratorConfiguration of(long allowedLateness, int lateEventsPerSessionWithinLateness, int lateEventsPerSessionOutsideLateness, long maxAdditionalSessionGap) {
        return new GeneratorConfiguration(allowedLateness, lateEventsPerSessionWithinLateness, lateEventsPerSessionOutsideLateness, maxAdditionalSessionGap);
    }

    public String toString() {
        return "GeneratorConfiguration{allowedLateness=" + this.allowedLateness + ", lateEventsWithinLateness=" + this.lateEventsWithinLateness + ", lateEventsAfterLateness=" + this.lateEventsAfterLateness + ", maxAdditionalSessionGap=" + this.maxAdditionalSessionGap + "}";
    }
}

