/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.legacy.io.TextOutputFormat;
import org.apache.flink.test.util.CoordVector;

public class PointFormatter
implements TextOutputFormat.TextFormatter<Tuple2<Integer, CoordVector>> {
    private static final long serialVersionUID = 1L;
    private final DecimalFormat df = new DecimalFormat("####0.00");
    private final StringBuilder line = new StringBuilder();

    public PointFormatter() {
        DecimalFormatSymbols dfSymbols = new DecimalFormatSymbols();
        dfSymbols.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(dfSymbols);
    }

    public String format(Tuple2<Integer, CoordVector> value) {
        this.line.setLength(0);
        this.line.append(value.f0);
        for (double coord : ((CoordVector)value.f1).getCoordinates()) {
            this.line.append('|');
            this.line.append(this.df.format(coord));
        }
        this.line.append('|');
        return this.line.toString();
    }
}

