/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorageAccess;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.streaming.util.StateBackendUtils;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class StateBackendITCase
extends AbstractTestBaseJUnit4 {
    @Test
    public void testStateBackendWithoutCheckpointing() throws Exception {
        StreamExecutionEnvironment see = StreamExecutionEnvironment.getExecutionEnvironment();
        see.setParallelism(1);
        StateBackendUtils.configureStateBackendWithFactory((StreamExecutionEnvironment)see, (String)"org.apache.flink.test.streaming.runtime.StateBackendITCase$FailingStateBackendFactory");
        RestartStrategyUtils.configureNoRestartStrategy((StreamExecutionEnvironment)see);
        see.fromData((Object[])new Tuple2[]{new Tuple2((Object)"Hello", (Object)1)}).keyBy((KeySelector & Serializable)x -> (String)x.f0).map((MapFunction)new RichMapFunction<Tuple2<String, Integer>, String>(){
            private static final long serialVersionUID = 1L;

            public void open(OpenContext openContext) throws Exception {
                super.open(openContext);
                this.getRuntimeContext().getState(new ValueStateDescriptor("Test", Integer.class));
            }

            public String map(Tuple2<String, Integer> value) throws Exception {
                return (String)value.f0;
            }
        }).print();
        try {
            see.execute();
            Assert.fail();
        }
        catch (JobExecutionException e) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)e, SuccessException.class).isPresent());
        }
    }

    static final class SuccessException
    extends IOException {
        private static final long serialVersionUID = -9218191172606739598L;

        SuccessException() {
        }
    }

    private static class FailingStateBackend
    implements StateBackend,
    CheckpointStorage {
        private static final long serialVersionUID = 1L;

        private FailingStateBackend() {
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
            return new MemoryBackendCheckpointStorageAccess(jobId, null, null, true, 1000000);
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws IOException {
            throw new SuccessException();
        }

        public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws Exception {
            throw new SuccessException();
        }
    }

    public static class FailingStateBackendFactory
    implements StateBackendFactory<FailingStateBackend> {
        public FailingStateBackend createFromConfig(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException, IOException {
            return new FailingStateBackend();
        }
    }
}

