/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime;

import java.io.IOException;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.legacy.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.junit.Assert;
import org.junit.Test;

public class GlobalAggregateITCase
extends AbstractTestBaseJUnit4 {
    @Test
    public void testSuccessfulUpdateToGlobalAggregate() throws Exception {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        streamExecutionEnvironment.addSource((SourceFunction)new TestSourceFunction(new IntegerAggregateFunction(), false)).sinkTo((Sink)new DiscardingSink());
        streamExecutionEnvironment.execute();
    }

    @Test
    public void testExceptionThrowingAggregateFunction() throws Exception {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        streamExecutionEnvironment.addSource((SourceFunction)new TestSourceFunction(new ExceptionThrowingAggregateFunction(), true)).sinkTo((Sink)new DiscardingSink());
        streamExecutionEnvironment.execute();
    }

    private static class ExceptionThrowingAggregateFunction
    implements AggregateFunction<Integer, Integer, Integer> {
        private ExceptionThrowingAggregateFunction() {
        }

        public Integer createAccumulator() {
            return 0;
        }

        public Integer add(Integer value, Integer accumulator) {
            throw new NullPointerException("test");
        }

        public Integer getResult(Integer accumulator) {
            return accumulator;
        }

        public Integer merge(Integer accumulatorA, Integer accumulatorB) {
            return this.add(accumulatorA, accumulatorB);
        }
    }

    private static class IntegerAggregateFunction
    implements AggregateFunction<Integer, Integer, Integer> {
        private IntegerAggregateFunction() {
        }

        public Integer createAccumulator() {
            return 0;
        }

        public Integer add(Integer value, Integer accumulator) {
            return value + accumulator;
        }

        public Integer getResult(Integer accumulator) {
            return accumulator;
        }

        public Integer merge(Integer accumulatorA, Integer accumulatorB) {
            return this.add(accumulatorA, accumulatorB);
        }
    }

    private static class TestSourceFunction
    extends RichSourceFunction<Integer> {
        private GlobalAggregateManager aggregateManager = null;
        private final AggregateFunction<Integer, Integer, Integer> aggregateFunction;
        private final boolean expectFailures;

        public TestSourceFunction(AggregateFunction<Integer, Integer, Integer> aggregateFunction, boolean expectFailures) {
            this.aggregateFunction = aggregateFunction;
            this.expectFailures = expectFailures;
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            StreamingRuntimeContext runtimeContext = (StreamingRuntimeContext)this.getRuntimeContext();
            this.aggregateManager = runtimeContext.getGlobalAggregateManager();
        }

        public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
            Integer expectedAccumulator = 0;
            int exceptionCount = 0;
            for (int i = 0; i < 5; ++i) {
                Integer actualAccumlator = 0;
                try {
                    actualAccumlator = (Integer)this.aggregateManager.updateGlobalAggregate("testAgg", (Object)i, this.aggregateFunction);
                    expectedAccumulator = expectedAccumulator + i;
                }
                catch (IOException e) {
                    ++exceptionCount;
                }
                if (this.expectFailures) {
                    Assert.assertEquals((long)(i + 1), (long)exceptionCount);
                    continue;
                }
                Assert.assertEquals((Object)expectedAccumulator, (Object)actualAccumlator);
            }
        }

        public void cancel() {
        }
    }
}

