/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api.environment;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.client.deployment.ClusterClientJobClientAdapter;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class RemoteStreamEnvironmentTest
extends TestLogger {
    @Test
    public void testPortForwarding() throws Exception {
        String host = "fakeHost";
        int port = 99;
        JobID jobId = new JobID();
        Configuration clientConfiguration = new Configuration();
        TestExecutorServiceLoader testExecutorServiceLoader = new TestExecutorServiceLoader(jobId);
        RemoteStreamEnvironment env = new RemoteStreamEnvironment((PipelineExecutorServiceLoader)testExecutorServiceLoader, host, port, clientConfiguration, null, null, null);
        env.fromData((Object[])new Integer[]{1}).map((MapFunction & Serializable)x -> x * 2);
        JobExecutionResult actualResult = env.execute("fakeJobName");
        TestClusterClient testClient = testExecutorServiceLoader.getCreatedClusterClient();
        Assert.assertThat((Object)actualResult.getJobID(), (Matcher)Matchers.is((Object)jobId));
        Assert.assertThat((Object)((String)testClient.getConfiguration().get(RestOptions.ADDRESS)), (Matcher)Matchers.is((Object)host));
        Assert.assertThat((Object)((Integer)testClient.getConfiguration().get(RestOptions.PORT)), (Matcher)Matchers.is((Object)99));
    }

    @Test
    public void testRemoteExecutionWithSavepoint() throws Exception {
        SavepointRestoreSettings restoreSettings = SavepointRestoreSettings.forPath((String)"fakePath");
        JobID jobID = new JobID();
        TestExecutorServiceLoader testExecutorServiceLoader = new TestExecutorServiceLoader(jobID);
        RemoteStreamEnvironment env = new RemoteStreamEnvironment((PipelineExecutorServiceLoader)testExecutorServiceLoader, "fakeHost", 1, null, new String[0], null, restoreSettings);
        env.fromData((Object[])new Integer[]{1}).map((MapFunction & Serializable)x -> x * 2);
        JobExecutionResult actualResult = env.execute("fakeJobName");
        Assert.assertThat((Object)actualResult.getJobID(), (Matcher)Matchers.is((Object)jobID));
        Assert.assertThat((Object)testExecutorServiceLoader.getActualSavepointRestoreSettings(), (Matcher)Matchers.is((Object)restoreSettings));
    }

    private static final class TestClusterClient
    implements ClusterClient<Object> {
        private final Configuration configuration;
        private final JobID jobId;

        public TestClusterClient(Configuration config, JobID jobId) {
            this.configuration = config;
            this.jobId = jobId;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public CompletableFuture<JobResult> requestJobResult(@Nonnull JobID jobId) {
            Assert.assertThat((Object)jobId, (Matcher)Matchers.is((Object)this.jobId));
            JobResult jobResult = new JobResult.Builder().jobId(this.jobId).netRuntime(0L).applicationStatus(ApplicationStatus.SUCCEEDED).build();
            return CompletableFuture.completedFuture(jobResult);
        }

        public CompletableFuture<JobID> submitJob(@Nonnull JobGraph jobGraph) {
            return CompletableFuture.completedFuture(this.jobId);
        }

        public void close() {
        }

        public Object getClusterId() {
            return null;
        }

        public Configuration getFlinkConfiguration() {
            return null;
        }

        public void shutDownCluster() {
        }

        public String getWebInterfaceURL() {
            return null;
        }

        public CompletableFuture<Collection<JobStatusMessage>> listJobs() throws Exception {
            return null;
        }

        public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) throws FlinkException {
            return null;
        }

        public CompletableFuture<JobStatus> getJobStatus(JobID jobId) {
            return null;
        }

        public CompletableFuture<Map<String, Object>> getAccumulators(JobID jobID, ClassLoader loader) {
            return null;
        }

        public CompletableFuture<Acknowledge> cancel(JobID jobId) {
            return null;
        }

        public CompletableFuture<String> cancelWithSavepoint(JobID jobId, @javax.annotation.Nullable String savepointDirectory, SavepointFormatType formatType) {
            return null;
        }

        public CompletableFuture<String> stopWithSavepoint(JobID jobId, boolean advanceToEndOfEventTime, @javax.annotation.Nullable String savepointDirectory, SavepointFormatType formatType) {
            return null;
        }

        public CompletableFuture<String> stopWithDetachedSavepoint(JobID jobId, boolean advanceToEndOfEventTime, @Nullable String savepointDirectory, SavepointFormatType formatType) {
            return null;
        }

        public CompletableFuture<String> triggerSavepoint(JobID jobId, @javax.annotation.Nullable String savepointDirectory, SavepointFormatType formatType) {
            return null;
        }

        public CompletableFuture<Long> triggerCheckpoint(JobID jobId, CheckpointType checkpointType) {
            return null;
        }

        public CompletableFuture<String> triggerDetachedSavepoint(JobID jobId, @Nullable String savepointDirectory, SavepointFormatType formatType) {
            return null;
        }

        public CompletableFuture<CoordinationResponse> sendCoordinationRequest(JobID jobId, String operatorUid, CoordinationRequest request) {
            return null;
        }
    }

    private static final class TestExecutorServiceLoader
    implements PipelineExecutorServiceLoader {
        private final JobID jobID;
        private TestClusterClient clusterClient;
        private SavepointRestoreSettings actualSavepointRestoreSettings;

        TestExecutorServiceLoader(JobID jobID) {
            this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        }

        public TestClusterClient getCreatedClusterClient() {
            return this.clusterClient;
        }

        public SavepointRestoreSettings getActualSavepointRestoreSettings() {
            return this.actualSavepointRestoreSettings;
        }

        public PipelineExecutorFactory getExecutorFactory(@Nonnull Configuration configuration) {
            return new PipelineExecutorFactory(){

                public String getName() {
                    return "my-name";
                }

                public boolean isCompatibleWith(@Nonnull Configuration configuration) {
                    return true;
                }

                public PipelineExecutor getExecutor(@Nonnull Configuration configuration) {
                    return (pipeline, config, classLoader) -> {
                        Assert.assertTrue((boolean)(pipeline instanceof StreamGraph));
                        actualSavepointRestoreSettings = SavepointRestoreSettings.fromConfiguration((ReadableConfig)config);
                        clusterClient = new TestClusterClient(configuration, jobID);
                        return CompletableFuture.completedFuture(new ClusterClientJobClientAdapter(() -> clusterClient, jobID, classLoader));
                    };
                }
            };
        }

        public Stream<String> getExecutorNames() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

