/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime.entrypoint;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.legacy.FileMonitoringFunction;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.util.ParameterTool;

public class StreamingNoop {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(2);
        RestartStrategyUtils.configureFixedDelayRestartStrategy((StreamExecutionEnvironment)env, (int)10, (long)1000L);
        env.readFileStream("input/", 60000L, FileMonitoringFunction.WatchType.ONLY_NEW_FILES).sinkTo((Sink)new DiscardingSink());
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        File jobGraphFile = new File(params.get("output", "job.graph"));
        try (FileOutputStream output = new FileOutputStream(jobGraphFile);
             ObjectOutputStream obOutput = new ObjectOutputStream(output);){
            obOutput.writeObject(jobGraph);
        }
    }
}

