/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SchedulingITCase
extends TestLogger {
    @Test
    public void testDisablingLocalRecovery() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)false);
        this.executeSchedulingTest(configuration);
    }

    @Test
    public void testLocalRecoveryFull() throws Exception {
        this.testLocalRecoveryInternal("full");
    }

    @Test
    public void testLocalRecoveryRegion() throws Exception {
        this.testLocalRecoveryInternal("region");
    }

    private void testLocalRecoveryInternal(String failoverStrategyValue) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)true);
        configuration.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY.key(), failoverStrategyValue);
        this.executeSchedulingTest(configuration);
    }

    private void executeSchedulingTest(Configuration configuration) throws Exception {
        long slotIdleTimeout = 50L;
        configuration.set(JobManagerOptions.SLOT_IDLE_TIMEOUT, (Object)Duration.ofMillis(50L));
        configuration.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)MemorySize.parse((String)"1g"));
        int parallelism = 4;
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().withRandomPorts().setConfiguration(configuration).setNumTaskManagers(4).setNumSlotsPerTaskManager(1).build();
        try (MiniCluster miniCluster = new MiniCluster(miniClusterConfiguration);){
            miniCluster.start();
            MiniClusterClient miniClusterClient = new MiniClusterClient(configuration, miniCluster);
            JobGraph jobGraph = this.createJobGraph(100L, 4);
            JobID jobID = (JobID)miniClusterClient.submitJob(jobGraph).get();
            CompletableFuture resultFuture = miniClusterClient.requestJobResult(jobID);
            JobResult jobResult = (JobResult)resultFuture.get();
            Assert.assertThat((Object)jobResult.getSerializedThrowable().isPresent(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Nonnull
    private JobGraph createJobGraph(long delay, int parallelism) throws IOException {
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        JobVertex source = new JobVertex("source");
        source.setInvokableClass(OneTimeFailingInvokable.class);
        source.setParallelism(parallelism);
        source.setSlotSharingGroup(slotSharingGroup);
        JobVertex sink = new JobVertex("sink");
        sink.setInvokableClass(NoOpInvokable.class);
        sink.setParallelism(parallelism);
        sink.setSlotSharingGroup(slotSharingGroup);
        sink.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobGraph jobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertices(Arrays.asList(source, sink)).build();
        RestartStrategyUtils.configureFixedDelayRestartStrategy((JobGraph)jobGraph, (int)1, (long)delay);
        return jobGraph;
    }

    public static final class OneTimeFailingInvokable
    extends AbstractInvokable {
        private static final AtomicBoolean hasFailed = new AtomicBoolean(false);

        public OneTimeFailingInvokable(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            if (hasFailed.compareAndSet(false, true)) {
                throw new FlinkException("One time failure.");
            }
        }
    }
}

