/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.runtime.BatchShuffleITCaseBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class HybridShuffleITCase
extends BatchShuffleITCaseBase {
    @Parameter
    public boolean enableAdaptiveAutoParallelism;

    HybridShuffleITCase() {
    }

    @Parameters(name="enableAdaptiveAutoParallelism={0}")
    public static Collection<Boolean[]> parameters() {
        return Arrays.asList({false}, {false}, {true});
    }

    @TestTemplate
    void testHybridFullExchanges() throws Exception {
        int numRecordsToSend = 10000;
        Configuration configuration = this.configureHybridOptions(this.getConfiguration(), false);
        JobGraph jobGraph = this.createJobGraph(10000, false, configuration, this.enableAdaptiveAutoParallelism);
        this.executeJob(jobGraph, configuration, 10000);
    }

    @TestTemplate
    void testHybridSelectiveExchanges() throws Exception {
        int numRecordsToSend = 10000;
        Configuration configuration = this.configureHybridOptions(this.getConfiguration(), true);
        JobGraph jobGraph = this.createJobGraph(10000, false, configuration, this.enableAdaptiveAutoParallelism);
        this.executeJob(jobGraph, configuration, 10000);
    }

    @TestTemplate
    void testHybridFullExchangesRestart() throws Exception {
        int numRecordsToSend = 10;
        Configuration configuration = this.configureHybridOptions(this.getConfiguration(), false);
        JobGraph jobGraph = this.createJobGraph(10, true, configuration, this.enableAdaptiveAutoParallelism);
        this.executeJob(jobGraph, configuration, 10);
    }

    @TestTemplate
    void testHybridSelectiveExchangesRestart() throws Exception {
        int numRecordsToSend = 10;
        Configuration configuration = this.configureHybridOptions(this.getConfiguration(), true);
        JobGraph jobGraph = this.createJobGraph(10, true, configuration, this.enableAdaptiveAutoParallelism);
        this.executeJob(jobGraph, configuration, 10);
    }

    private Configuration configureHybridOptions(Configuration configuration, boolean isSelective) {
        BatchShuffleMode shuffleMode = isSelective ? BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE : BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL;
        configuration.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        if (isSelective) {
            configuration.setString(TaskManagerOptions.NETWORK_MEMORY_MAX.key(), "128m");
        }
        return configuration;
    }
}

