/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.functions.source.legacy.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.util.CheckpointStorageUtils;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.streaming.util.StateBackendUtils;
import org.apache.flink.test.recovery.AbstractTaskManagerProcessFailureRecoveryTest;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class TaskManagerProcessFailureStreamingRecoveryITCase
extends AbstractTaskManagerProcessFailureRecoveryTest {
    private static final int DATA_COUNT = 10000;

    TaskManagerProcessFailureStreamingRecoveryITCase() {
    }

    @Override
    public void testTaskManagerFailure(Configuration configuration, File coordinateDir) throws Exception {
        File tempCheckpointDir = TempDirUtils.newFolder((Path)this.temporaryFolder);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)1337, (Configuration)configuration, (String[])new String[0]);
        env.setParallelism(4);
        RestartStrategyUtils.configureFixedDelayRestartStrategy((StreamExecutionEnvironment)env, (int)1, (long)1000L);
        env.enableCheckpointing(200L);
        StateBackendUtils.configureHashMapStateBackend((StreamExecutionEnvironment)env);
        CheckpointStorageUtils.configureFileSystemCheckpointStorage((StreamExecutionEnvironment)env, (URI)tempCheckpointDir.getAbsoluteFile().toURI());
        SingleOutputStreamOperator result = env.addSource((SourceFunction)new SleepyDurableGenerateSequence(coordinateDir, 10000L)).map((MapFunction)new MapFunction<Long, Long>(){

            public Long map(Long value) throws Exception {
                return value;
            }
        }).startNewChain().map((MapFunction)new Mapper(coordinateDir));
        result.addSink((SinkFunction)new CheckpointedSink(10000L));
        env.execute();
    }

    private static class CheckpointedSink
    extends RichSinkFunction<Long>
    implements ListCheckpointed<Long> {
        private long stepSize;
        private long congruence;
        private long toCollect;
        private Long collected = 0L;
        private long end;

        public CheckpointedSink(long end) {
            this.end = end;
        }

        public void open(OpenContext openContext) throws IOException {
            this.stepSize = this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks();
            this.congruence = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
            this.toCollect = this.end % this.stepSize > this.congruence ? this.end / this.stepSize + 1L : this.end / this.stepSize;
        }

        public void invoke(Long value) throws Exception {
            long expected = this.collected * this.stepSize + this.congruence;
            ((AbstractLongAssert)Assertions.assertThat((Long)value).withFailMessage("Value did not match expected value. " + expected + " != " + value, new Object[0])).isEqualTo(expected);
            Long l = this.collected;
            Long l2 = this.collected = Long.valueOf(this.collected + 1L);
            ((AbstractLongAssert)Assertions.assertThat((Long)this.collected).withFailMessage("Collected <= toCollect: " + this.collected + " > " + this.toCollect, new Object[0])).isLessThanOrEqualTo(this.toCollect);
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.collected);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.size() != 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.collected = state.get(0);
        }
    }

    private static class Mapper
    extends RichMapFunction<Long, Long> {
        private boolean markerCreated = false;
        private File coordinateDir;

        public Mapper(File coordinateDir) {
            this.coordinateDir = coordinateDir;
        }

        public Long map(Long value) throws Exception {
            if (!this.markerCreated) {
                int taskIndex = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
                AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(this.coordinateDir, "ready_" + taskIndex));
                this.markerCreated = true;
            }
            return value;
        }
    }

    private static class SleepyDurableGenerateSequence
    extends RichParallelSourceFunction<Long>
    implements ListCheckpointed<Long> {
        private static final long SLEEP_TIME = 50L;
        private final File coordinateDir;
        private final long end;
        private volatile boolean isRunning = true;
        private long collected;

        public SleepyDurableGenerateSequence(File coordinateDir, long end) {
            this.coordinateDir = coordinateDir;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<Long> sourceCtx) throws Exception {
            long congruence;
            Object checkpointLock = sourceCtx.getCheckpointLock();
            RuntimeContext runtimeCtx = this.getRuntimeContext();
            long stepSize = runtimeCtx.getTaskInfo().getNumberOfParallelSubtasks();
            long toCollect = this.end % stepSize > (congruence = (long)runtimeCtx.getTaskInfo().getIndexOfThisSubtask()) ? this.end / stepSize + 1L : this.end / stepSize;
            File proceedFile = new File(this.coordinateDir, "proceed");
            boolean checkForProceedFile = true;
            while (this.isRunning && this.collected < toCollect) {
                if (checkForProceedFile) {
                    if (proceedFile.exists()) {
                        checkForProceedFile = false;
                    } else {
                        Thread.sleep(50L);
                    }
                }
                Object object = checkpointLock;
                synchronized (object) {
                    sourceCtx.collect((Object)(this.collected * stepSize + congruence));
                    ++this.collected;
                }
            }
        }

        public void cancel() {
            this.isRunning = false;
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.collected);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.collected = state.get(0);
        }
    }
}

